/*
 * Decompiled with CFR 0.152.
 */
package de.otto.kafka.messaging.e2ee.fieldlevel;

import de.otto.kafka.messaging.e2ee.EncryptionKeyProvider;
import de.otto.kafka.messaging.e2ee.EncryptionService;
import de.otto.kafka.messaging.e2ee.fieldlevel.EncryptedString;
import de.otto.kafka.messaging.e2ee.fieldlevel.FieldLevelEncryptionService;
import java.util.Objects;

public class SingleTopicFieldLevelEncryptionService {
    private final FieldLevelEncryptionService fieldLevelEncryptionService;
    private final String kafkaTopicName;

    public SingleTopicFieldLevelEncryptionService(FieldLevelEncryptionService fieldLevelEncryptionService, String kafkaTopicName) {
        Objects.requireNonNull(fieldLevelEncryptionService, "fieldLevelEncryptionService");
        Objects.requireNonNull(kafkaTopicName, "kafkaTopicName");
        this.fieldLevelEncryptionService = fieldLevelEncryptionService;
        this.kafkaTopicName = kafkaTopicName;
    }

    public SingleTopicFieldLevelEncryptionService(EncryptionService encryptionService, String kafkaTopicName) {
        this(new FieldLevelEncryptionService(encryptionService), kafkaTopicName);
    }

    public SingleTopicFieldLevelEncryptionService(EncryptionKeyProvider encryptionKeyProvider, String kafkaTopicName) {
        this(new EncryptionService(encryptionKeyProvider), kafkaTopicName);
    }

    public String encryptFieldValueToString(String plainText) {
        return this.fieldLevelEncryptionService.encryptFieldValueToString(this.kafkaTopicName, plainText);
    }

    public EncryptedString encryptToEncryptedString(String plainText) {
        return this.fieldLevelEncryptionService.encryptFieldValueToEncryptedString(this.kafkaTopicName, plainText);
    }
}

