/*
 * Decompiled with CFR 0.152.
 */
package de.otto.kafka.messaging.e2ee.fieldlevel;

import de.otto.kafka.messaging.e2ee.AesEncryptedPayload;
import de.otto.kafka.messaging.e2ee.DecryptionService;
import de.otto.kafka.messaging.e2ee.EncryptionKeyProvider;
import de.otto.kafka.messaging.e2ee.fieldlevel.EncryptedString;
import java.util.Base64;
import java.util.Objects;
import java.util.regex.Pattern;

public class FieldLevelDecryptionService {
    private final DecryptionService decryptionService;

    public FieldLevelDecryptionService(DecryptionService decryptionService) {
        Objects.requireNonNull(decryptionService, "decryptionService");
        this.decryptionService = decryptionService;
    }

    public FieldLevelDecryptionService(EncryptionKeyProvider encryptionKeyProvider) {
        this(new DecryptionService(encryptionKeyProvider));
    }

    public String decryptFieldValue(String kafkaTopicName, String encryptedString) {
        int keyVersion;
        Objects.requireNonNull(kafkaTopicName, "kafkaTopicName");
        if (encryptedString == null) {
            return null;
        }
        if (!encryptedString.startsWith("encAesV1.")) {
            return encryptedString;
        }
        String[] cryptoParts = encryptedString.split(Pattern.quote("."));
        if (cryptoParts.length != 4) {
            throw new IllegalArgumentException("encrypted string format is invalid");
        }
        try {
            keyVersion = Integer.parseInt(cryptoParts[1]);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("keyVersion must be a number", ex);
        }
        String initializationVectorBase64 = cryptoParts[2];
        byte[] encryptedPayload = Base64.getDecoder().decode(cryptoParts[3]);
        AesEncryptedPayload aesEncryptedPayload = new AesEncryptedPayload(encryptedPayload, initializationVectorBase64, keyVersion);
        return this.decryptionService.decryptToString(kafkaTopicName, aesEncryptedPayload);
    }

    public String decryptFieldValue(String kafkaTopicName, EncryptedString encryptedString) {
        if (encryptedString == null || encryptedString.value() == null) {
            return null;
        }
        return this.decryptFieldValue(kafkaTopicName, encryptedString.value());
    }
}

