/*
 * Decompiled with CFR 0.152.
 */
package de.otto.messaging.kafka.e2ee.vault;

import de.otto.messaging.kafka.e2ee.vault.RenewableVault;
import de.otto.messaging.kafka.e2ee.vault.VaultConfigException;
import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import java.util.Objects;

public record VaultConnectionConfig(String address, String token, VaultAppRole appRole) {
    private static final String DEFAULT_VAULT_URL = "http://localhost:8200";

    public VaultConnectionConfig(String address, String token, VaultAppRole appRole) {
        if (appRole != null && token != null) {
            throw new VaultConfigException("Vault token must not be configured when appRole is provided");
        }
        if (appRole == null && token == null) {
            throw new VaultConfigException("Neither vault token nor appRole is provided");
        }
        this.address = Objects.requireNonNullElse(address, DEFAULT_VAULT_URL);
        this.token = token;
        this.appRole = appRole;
    }

    public static VaultConnectionConfigBuilder builder() {
        return new VaultConnectionConfigBuilder();
    }

    public RenewableVault createRenewableVault() throws VaultException {
        VaultConfig config = new VaultConfig().address(this.address).token(this.token).openTimeout(Integer.valueOf(5)).readTimeout(Integer.valueOf(30)).engineVersion(Integer.valueOf(2)).build();
        if (this.token != null) {
            return new RenewableVault(config);
        }
        return new RenewableVault(config, this.appRole);
    }

    public record VaultAppRole(String path, String roleid, String secretid) {
        public VaultAppRole {
            Objects.requireNonNull(path, "path is required");
            Objects.requireNonNull(roleid, "roleid is required");
            Objects.requireNonNull(secretid, "secretid is required");
        }

        public static AppRoleBuilder builder() {
            return new AppRoleBuilder();
        }

        public static class AppRoleBuilder {
            private String path;
            private String roleid;
            private String secretid;

            public AppRoleBuilder path(String path) {
                this.path = path;
                return this;
            }

            public AppRoleBuilder roleid(String roleid) {
                this.roleid = roleid;
                return this;
            }

            public AppRoleBuilder secretid(String secretid) {
                this.secretid = secretid;
                return this;
            }

            public VaultAppRole build() {
                return new VaultAppRole(this.path, this.roleid, this.secretid);
            }
        }
    }

    public static class VaultConnectionConfigBuilder {
        private String address;
        private String token;
        private VaultAppRole appRole;

        public VaultConnectionConfigBuilder address(String address) {
            this.address = address;
            return this;
        }

        public VaultConnectionConfigBuilder token(String token) {
            this.token = token;
            return this;
        }

        public VaultConnectionConfigBuilder appRole(VaultAppRole appRole) {
            this.appRole = appRole;
            return this;
        }

        public VaultConnectionConfig build() {
            return new VaultConnectionConfig(this.address, this.token, this.appRole);
        }
    }
}

