/*
 * Decompiled with CFR 0.152.
 */
package de.otto.messaging.kafka.e2ee.fieldlevel;

import de.otto.messaging.kafka.e2ee.DecryptionService;
import de.otto.messaging.kafka.e2ee.EncryptionKeyProvider;
import de.otto.messaging.kafka.e2ee.fieldlevel.EncryptedString;
import de.otto.messaging.kafka.e2ee.fieldlevel.FieldLevelDecryptionService;
import java.util.Objects;

public class SingleTopicFieldLevelDecryptionService {
    private final FieldLevelDecryptionService fieldLevelDecryptionService;
    private final String kafkaTopicName;

    public SingleTopicFieldLevelDecryptionService(FieldLevelDecryptionService fieldLevelDecryptionService, String kafkaTopicName) {
        Objects.requireNonNull(fieldLevelDecryptionService, "fieldLevelDecryptionService");
        Objects.requireNonNull(kafkaTopicName, "kafkaTopicName");
        this.fieldLevelDecryptionService = fieldLevelDecryptionService;
        this.kafkaTopicName = kafkaTopicName;
    }

    public SingleTopicFieldLevelDecryptionService(DecryptionService decryptionService, String kafkaTopicName) {
        this(new FieldLevelDecryptionService(decryptionService), kafkaTopicName);
    }

    public SingleTopicFieldLevelDecryptionService(EncryptionKeyProvider encryptionKeyProvider, String kafkaTopicName) {
        this(new DecryptionService(encryptionKeyProvider), kafkaTopicName);
    }

    public String decrypt(String encryptedString) {
        return this.fieldLevelDecryptionService.decryptFieldValue(this.kafkaTopicName, encryptedString);
    }

    public String decrypt(EncryptedString encryptedString) {
        return this.fieldLevelDecryptionService.decryptFieldValue(this.kafkaTopicName, encryptedString);
    }
}

