/*
 * Decompiled with CFR 0.152.
 */
package de.otto.messaging.kafka.e2ee.fieldlevel;

import de.otto.messaging.kafka.e2ee.AesEncryptedPayload;
import de.otto.messaging.kafka.e2ee.EncryptionKeyProvider;
import de.otto.messaging.kafka.e2ee.EncryptionService;
import de.otto.messaging.kafka.e2ee.fieldlevel.EncryptedString;
import java.util.Base64;
import java.util.Objects;

public class FieldLevelEncryptionService {
    private final EncryptionService encryptionService;

    public FieldLevelEncryptionService(EncryptionService encryptionService) {
        Objects.requireNonNull(encryptionService, "encryptionService");
        this.encryptionService = encryptionService;
    }

    public FieldLevelEncryptionService(EncryptionKeyProvider encryptionKeyProvider) {
        this(new EncryptionService(encryptionKeyProvider));
    }

    public String encryptFieldValueToString(String kafkaTopicName, String plainText) {
        Objects.requireNonNull(kafkaTopicName, "kafkaTopicName");
        if (plainText == null) {
            return null;
        }
        AesEncryptedPayload aesEncryptedPayload = this.encryptionService.encryptPayloadWithAes(kafkaTopicName, plainText);
        if (!aesEncryptedPayload.isEncrypted()) {
            return plainText;
        }
        String encryptedPayloadBase64 = Base64.getEncoder().encodeToString(aesEncryptedPayload.encryptedPayload());
        return "encAesV1." + aesEncryptedPayload.keyVersion() + "." + aesEncryptedPayload.initializationVectorBase64() + "." + encryptedPayloadBase64;
    }

    public EncryptedString encryptFieldValueToEncryptedString(String kafkaTopicName, String plainText) {
        return EncryptedString.of(this.encryptFieldValueToString(kafkaTopicName, plainText));
    }
}

