/*
 * Decompiled with CFR 0.152.
 */
package de.otto.messaging.kafka.e2ee;

import de.otto.messaging.kafka.e2ee.AesEncryptedPayload;
import de.otto.messaging.kafka.e2ee.EncryptionCipherSpec;
import de.otto.messaging.kafka.e2ee.JsonParsingRuntimeException;
import io.github.jopenlibs.vault.json.Json;
import io.github.jopenlibs.vault.json.JsonArray;
import io.github.jopenlibs.vault.json.JsonObject;
import io.github.jopenlibs.vault.json.JsonValue;
import io.github.jopenlibs.vault.json.WriterConfig;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public interface KafkaEncryptionHelper {
    public static final String KAFKA_HEADER_IV_KEY = "encryption/key/iv";
    public static final String KAFKA_HEADER_IV_VALUE = "encryption/iv";
    public static final String KAFKA_HEADER_CIPHER_KEY = "encryption/key/ciphers";
    public static final String KAFKA_HEADER_CIPHER_VALUE = "encryption/ciphers";

    public static String headerNameIv(boolean isForKey) {
        if (isForKey) {
            return KAFKA_HEADER_IV_KEY;
        }
        return KAFKA_HEADER_IV_VALUE;
    }

    public static String headerNameCiphers(boolean isForKey) {
        if (isForKey) {
            return KAFKA_HEADER_CIPHER_KEY;
        }
        return KAFKA_HEADER_CIPHER_VALUE;
    }

    public static AesEncryptedPayload aesEncryptedPayloadOfKafka(byte[] encryptedPayload, String kafkaHeaderInitializationVector, String kafkaHeaderCiphersText) {
        if (kafkaHeaderInitializationVector == null || kafkaHeaderCiphersText == null) {
            return AesEncryptedPayload.ofUnencryptedPayload(encryptedPayload);
        }
        EncryptionCipherSpec cipherSpec = KafkaEncryptionHelper.extractCipherSpec(kafkaHeaderCiphersText);
        return AesEncryptedPayload.ofEncryptedPayload(encryptedPayload, kafkaHeaderInitializationVector, cipherSpec);
    }

    public static AesEncryptedPayload aesEncryptedPayloadOfKafka(byte[] encryptedPayload, byte[] kafkaHeaderInitializationVector, byte[] kafkaHeaderCiphersText) {
        return KafkaEncryptionHelper.aesEncryptedPayloadOfKafka(encryptedPayload, KafkaEncryptionHelper.byteArrayToUtf8String(kafkaHeaderInitializationVector), KafkaEncryptionHelper.byteArrayToUtf8String(kafkaHeaderCiphersText));
    }

    public static AesEncryptedPayload aesEncryptedPayloadOfKafkaForKey(byte[] encryptedPayload, Map<String, ?> kafkaHeaders) {
        String kafkaHeaderInitializationVector = KafkaEncryptionHelper.extractKafkaHeaderValueText(kafkaHeaders, KafkaEncryptionHelper.headerNameIv(true));
        String kafkaHeaderCiphersText = KafkaEncryptionHelper.extractKafkaHeaderValueText(kafkaHeaders, KafkaEncryptionHelper.headerNameCiphers(true));
        return KafkaEncryptionHelper.aesEncryptedPayloadOfKafka(encryptedPayload, kafkaHeaderInitializationVector, kafkaHeaderCiphersText);
    }

    public static AesEncryptedPayload aesEncryptedPayloadOfKafkaForValue(byte[] encryptedPayload, Map<String, ?> kafkaHeaders) {
        String kafkaHeaderInitializationVector = KafkaEncryptionHelper.extractKafkaHeaderValueText(kafkaHeaders, KafkaEncryptionHelper.headerNameIv(false));
        String kafkaHeaderCiphersText = KafkaEncryptionHelper.extractKafkaHeaderValueText(kafkaHeaders, KafkaEncryptionHelper.headerNameCiphers(false));
        return KafkaEncryptionHelper.aesEncryptedPayloadOfKafka(encryptedPayload, kafkaHeaderInitializationVector, kafkaHeaderCiphersText);
    }

    public static String extractKafkaHeaderValueText(Map<String, ?> kafkaHeaders, String headerName) {
        Object value = kafkaHeaders.get(headerName);
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return KafkaEncryptionHelper.byteArrayToUtf8String(bytes);
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static String byteArrayToUtf8String(byte[] kafkaHeaderValue) {
        if (kafkaHeaderValue == null) {
            return null;
        }
        return new String(kafkaHeaderValue, StandardCharsets.UTF_8);
    }

    public static Map<String, byte[]> mapToKafkaHeadersForKey(AesEncryptedPayload encryptedPayload) {
        if (encryptedPayload.isEncrypted()) {
            return Map.of(KafkaEncryptionHelper.headerNameIv(true), KafkaEncryptionHelper.mapToIvHeaderValue(encryptedPayload), KafkaEncryptionHelper.headerNameCiphers(true), KafkaEncryptionHelper.mapToCipherHeaderValue(encryptedPayload));
        }
        return Map.of();
    }

    public static Map<String, byte[]> mapToKafkaHeadersForValue(AesEncryptedPayload encryptedPayload) {
        if (encryptedPayload.isEncrypted()) {
            return Map.of(KafkaEncryptionHelper.headerNameIv(false), KafkaEncryptionHelper.mapToIvHeaderValue(encryptedPayload), KafkaEncryptionHelper.headerNameCiphers(false), KafkaEncryptionHelper.mapToCipherHeaderValue(encryptedPayload));
        }
        return Map.of();
    }

    public static String mapToIvHeaderValueText(AesEncryptedPayload encryptedPayload) {
        return encryptedPayload.initializationVectorBase64();
    }

    public static byte[] mapToIvHeaderValue(AesEncryptedPayload encryptedPayload) {
        if (encryptedPayload.isEncrypted()) {
            return KafkaEncryptionHelper.mapToIvHeaderValueText(encryptedPayload).getBytes(StandardCharsets.UTF_8);
        }
        throw new IllegalArgumentException("Cannot call 'mapToIvHeaderValue' for unencrypted payloads.");
    }

    public static String mapToCipherHeaderValueText(AesEncryptedPayload encryptedPayload) {
        String encryptionKeyName = encryptedPayload.encryptionKeyAttributeName();
        if (encryptionKeyName == null) {
            encryptionKeyName = "encryption_key";
        }
        JsonObject jsonObjectCipher = new JsonObject();
        jsonObjectCipher.add("cipherVersion", Json.value((int)encryptedPayload.keyVersion()));
        jsonObjectCipher.add("cipherVersionString", Json.NULL);
        jsonObjectCipher.add("cipherName", Json.value((String)encryptionKeyName));
        JsonObject jsonObjectEncryption = new JsonObject();
        jsonObjectEncryption.add(encryptionKeyName, (JsonValue)jsonObjectCipher);
        JsonArray jsonArrayRoot = new JsonArray();
        jsonArrayRoot.add((JsonValue)jsonObjectEncryption);
        return jsonArrayRoot.toString(WriterConfig.MINIMAL);
    }

    public static String mapToCipherHeaderValueText(EncryptionCipherSpec cipherSpec) {
        String encryptionKeyName = cipherSpec.cipherName();
        if (encryptionKeyName == null) {
            encryptionKeyName = "encryption_key";
        }
        JsonObject jsonObjectCipher = new JsonObject();
        jsonObjectCipher.add("cipherVersion", Json.value((int)cipherSpec.keyVersion()));
        jsonObjectCipher.add("cipherVersionString", Json.NULL);
        jsonObjectCipher.add("cipherName", Json.value((String)encryptionKeyName));
        JsonObject jsonObjectEncryption = new JsonObject();
        jsonObjectEncryption.add(encryptionKeyName, (JsonValue)jsonObjectCipher);
        JsonArray jsonArrayRoot = new JsonArray();
        jsonArrayRoot.add((JsonValue)jsonObjectEncryption);
        return jsonArrayRoot.toString(WriterConfig.MINIMAL);
    }

    public static byte[] mapToCipherHeaderValue(AesEncryptedPayload encryptedPayload) {
        if (encryptedPayload.isEncrypted()) {
            return KafkaEncryptionHelper.mapToCipherHeaderValueText(encryptedPayload).getBytes(StandardCharsets.UTF_8);
        }
        throw new IllegalArgumentException("Cannot call 'mapToCipherHeaderValue' for unencrypted payloads.");
    }

    public static byte[] extractIv(byte[] ivRaw) {
        if (ivRaw == null) {
            return new byte[0];
        }
        return KafkaEncryptionHelper.extractIv(new String(ivRaw, StandardCharsets.UTF_8));
    }

    public static byte[] extractIv(String ivText) {
        if (ivText == null) {
            return new byte[0];
        }
        return Base64.getDecoder().decode(ivText);
    }

    public static int extractKeyVersion(byte[] cipherHeaderValue) {
        if (cipherHeaderValue == null) {
            return 0;
        }
        String ciphersText = new String(cipherHeaderValue, StandardCharsets.UTF_8);
        return KafkaEncryptionHelper.extractKeyVersion(ciphersText);
    }

    public static int extractKeyVersion(String ciphersText) {
        EncryptionCipherSpec cipherSpec = KafkaEncryptionHelper.extractCipherSpec(ciphersText);
        if (cipherSpec == null) {
            return 0;
        }
        return cipherSpec.keyVersion();
    }

    public static String extractEncryptionKeyAttributeName(String ciphersText) {
        EncryptionCipherSpec cipherSpec = KafkaEncryptionHelper.extractCipherSpec(ciphersText);
        if (cipherSpec == null) {
            return null;
        }
        return cipherSpec.cipherName();
    }

    public static EncryptionCipherSpec extractCipherSpec(byte[] cipherHeaderValue) {
        if (cipherHeaderValue == null) {
            return null;
        }
        String ciphersText = new String(cipherHeaderValue, StandardCharsets.UTF_8);
        return KafkaEncryptionHelper.extractCipherSpec(ciphersText);
    }

    public static EncryptionCipherSpec extractCipherSpec(String ciphersText) {
        if (ciphersText == null) {
            return null;
        }
        try {
            JsonArray jsonArrayRoot = Json.parse((String)ciphersText).asArray();
            if (jsonArrayRoot.size() != 1) {
                throw new JsonParsingRuntimeException("Cannot parse cipher. Error=CipherText has not exactly one element. Cipher=" + ciphersText);
            }
            JsonObject jsonObjectEncryption = jsonArrayRoot.get(0).asObject();
            List jsonElementNames = jsonObjectEncryption.names();
            if (jsonElementNames.size() != 1) {
                throw new JsonParsingRuntimeException("Cannot parse cipher. Error=Root object has not exactly one element. Cipher=" + ciphersText);
            }
            String cipherName = (String)jsonElementNames.get(0);
            JsonObject jsonAes = jsonObjectEncryption.get(cipherName).asObject();
            int keyVersion = jsonAes.getInt("cipherVersion");
            return new EncryptionCipherSpec(keyVersion, cipherName);
        }
        catch (JsonParsingRuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JsonParsingRuntimeException("Cannot parse cipher. Error=" + ex.getMessage() + " Cipher=" + ciphersText);
        }
    }
}

