/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jsonhome.registry.store;

import de.otto.jsonhome.registry.store.Link;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Registry {
    private final String name;
    private final String title;
    private final List<Link> links;

    public Registry(String name, String title, List<Link> links) {
        if (name == null) {
            throw new NullPointerException("Name of Links must not be null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name of Links must not be empty");
        }
        this.name = name;
        this.title = title;
        this.links = Collections.unmodifiableList(new ArrayList<Link>(links));
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public Collection<Link> getAll() {
        return this.links;
    }

    public Link findByHref(URI href) {
        for (Link link : this.links) {
            if (!link.getHref().equals(href)) continue;
            return link;
        }
        return null;
    }

    public Link asLinkFor(URI baseUri) {
        URI uri = baseUri.toString().endsWith("/") ? baseUri.resolve("registries/" + this.name) : URI.create(baseUri.toString() + "/registries/" + this.name);
        return new Link(uri, this.title);
    }
}

