/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jsonhome.registry.controller;

import de.otto.jsonhome.annotation.Doc;
import de.otto.jsonhome.model.JsonHome;
import de.otto.jsonhome.model.ResourceLink;
import de.otto.jsonhome.registry.controller.RegistryJsonHomeSource;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class RegistryHtmlController {
    private static Logger LOG = LoggerFactory.getLogger(RegistryHtmlController.class);
    private RegistryJsonHomeSource registryJsonHomeSource;
    private int maxAge = 3600;
    private String defaultRegistry = "default";

    @Autowired
    public void setRegistryJsonHomeSource(RegistryJsonHomeSource registryJsonHomeSource) {
        this.registryJsonHomeSource = registryJsonHomeSource;
    }

    public void setMaxAgeSeconds(int maxAge) {
        this.maxAge = maxAge;
        LOG.info("MaxAge is {}", (Object)maxAge);
    }

    @Value(value="${jsonhome.defaultRegistry}")
    public void setDefaultRegistry(String defaultRegistry) {
        this.defaultRegistry = defaultRegistry;
    }

    @RequestMapping(value={"/json-home"}, method={RequestMethod.GET}, produces={"text/html"})
    @ResponseBody
    public ModelAndView getHtmlHomeDocument(@RequestParam(required=false) @Doc(value={"The name of the json-home registry."}) String registry, HttpServletRequest request, HttpServletResponse response) {
        String selectedRegistry = registry != null ? registry : this.defaultRegistry;
        JsonHome jsonHome = this.registryJsonHomeSource.getJsonHome(selectedRegistry);
        response.setHeader("Cache-Control", "max-age=" + this.maxAge);
        response.setHeader("Vary", "Accept");
        HashMap<String, Object> resources = new HashMap<String, Object>();
        resources.put("resources", jsonHome.getResources().values());
        resources.put("contextpath", request.getContextPath());
        if (registry != null) {
            resources.put("relQuery", "?registry=" + registry);
        }
        return new ModelAndView("resources", resources);
    }

    @RequestMapping(value={"/rel/**"}, method={RequestMethod.GET}, produces={"text/html"})
    public ModelAndView getRelationshipType(@RequestParam(required=false) @Doc(value={"The name of the json-home registry."}) String registry, HttpServletRequest request) {
        String selectedRegistry;
        URI relationTypeURI = URI.create(request.getRequestURL().toString());
        ResourceLink resourceLink = this.resourceLink(relationTypeURI, selectedRegistry = registry != null ? registry : this.defaultRegistry);
        if (resourceLink != null) {
            HashMap<String, String> model = new HashMap<String, String>();
            model.put("contextpath", request.getContextPath());
            model.put("resource", (String)resourceLink);
            if (resourceLink.isDirectLink()) {
                return new ModelAndView("directresource", model);
            }
            return new ModelAndView("templatedresource", model);
        }
        throw new IllegalArgumentException("Unknown relation type " + relationTypeURI);
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={IllegalArgumentException.class})
    public void handleNotFound(IllegalArgumentException e, HttpServletResponse response) throws IOException {
        response.sendError(404, e.getMessage());
    }

    private ResourceLink resourceLink(URI relationType, String selectedRegistry) {
        JsonHome jsonHome = this.registryJsonHomeSource.getJsonHome(selectedRegistry);
        return jsonHome.getResourceFor(relationType);
    }
}

