/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jsonhome.registry.controller;

import de.otto.jsonhome.registry.controller.LinkConverter;
import de.otto.jsonhome.registry.store.Link;
import de.otto.jsonhome.registry.store.Registry;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RegistryConverter {
    private RegistryConverter() {
    }

    public static Registry jsonToRegistry(Map<String, ?> map) {
        try {
            ArrayList<Link> links = new ArrayList<Link>();
            List linksMap = (List)map.get("service");
            for (Map linkMap : linksMap) {
                links.add(LinkConverter.jsonToLink(linkMap));
            }
            return new Registry((String)map.get("name"), (String)map.get("title"), links);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Map does not contain valid links", e);
        }
    }

    public static Map<String, Object> registryToJson(URI baseUri, Registry registry) {
        LinkedHashMap<String, Object> content = new LinkedHashMap<String, Object>();
        content.put("name", registry.getName());
        content.put("title", registry.getTitle());
        content.put("self", baseUri + "/registries/" + registry.getName());
        content.put("container", baseUri + "/registries");
        ArrayList<Map<String, String>> linksList = new ArrayList<Map<String, String>>();
        for (Link link : registry.getAll()) {
            linksList.add(LinkConverter.linkToJson(link));
        }
        content.put("service", linksList);
        return content;
    }
}

