/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jsonhome.registry.controller;

import de.otto.jsonhome.annotation.Doc;
import de.otto.jsonhome.controller.JsonHomeController;
import de.otto.jsonhome.converter.JsonHomeConverter;
import de.otto.jsonhome.converter.JsonHomeMediaType;
import de.otto.jsonhome.model.JsonHome;
import de.otto.jsonhome.registry.controller.RegistryJsonHomeSource;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RegistryJsonHomeController {
    private static Logger LOG = LoggerFactory.getLogger(JsonHomeController.class);
    private RegistryJsonHomeSource jsonHomeSource;
    private int maxAge = 3600;
    private String defaultRegistry = "default";

    @Autowired
    public void setRegistryJsonHomeSource(RegistryJsonHomeSource registryJsonHomeSource) {
        this.jsonHomeSource = registryJsonHomeSource;
    }

    public void setMaxAgeSeconds(int maxAge) {
        this.maxAge = maxAge;
        LOG.info("MaxAge is {}", (Object)maxAge);
    }

    @Value(value="${jsonhome.defaultRegistry}")
    public void setDefaultRegistry(String defaultRegistry) {
        this.defaultRegistry = defaultRegistry;
    }

    @RequestMapping(value={"/json-home"}, produces={"application/json-home"})
    @ResponseBody
    public Map<String, ?> getAsApplicationJsonHome(@RequestParam(required=false) @Doc(value={"The name of the json-home registry."}) String registry, HttpServletResponse response) {
        LOG.info("Returning json-home in application/json-home format.");
        response.setHeader("Cache-Control", "max-age=" + this.maxAge);
        response.setHeader("Vary", "Accept");
        String selectedRegistry = registry != null ? registry : this.defaultRegistry;
        return JsonHomeConverter.toRepresentation((JsonHome)this.jsonHomeSource.getJsonHome(selectedRegistry), (JsonHomeMediaType)JsonHomeMediaType.APPLICATION_JSONHOME);
    }

    @RequestMapping(value={"/json-home"}, produces={"application/json"})
    @ResponseBody
    public Map<String, ?> getAsApplicationJson(@RequestParam(required=false) @Doc(value={"The name of the json-home registry."}) String registry, HttpServletResponse response) {
        LOG.info("Returning json-home in application/json format.");
        response.setHeader("Cache-Control", "max-age=" + this.maxAge);
        response.setHeader("Vary", "Accept");
        try {
            String selectedRegistry = registry != null ? registry : this.defaultRegistry;
            return JsonHomeConverter.toRepresentation((JsonHome)this.jsonHomeSource.getJsonHome(selectedRegistry), (JsonHomeMediaType)JsonHomeMediaType.APPLICATION_JSON);
        }
        catch (IllegalArgumentException e) {
            try {
                response.sendError(404, e.getMessage());
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw e;
        }
    }
}

