/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jsonhome.registry.controller;

import de.otto.jsonhome.registry.controller.LinkConverter;
import de.otto.jsonhome.registry.store.Link;
import de.otto.jsonhome.registry.store.RegistryRepository;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RegistriesConverter {
    private RegistriesConverter() {
    }

    public static Map<String, ?> registriesToJson(URI baseUri, RegistryRepository repository) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("self", baseUri + "/registries");
        json.put("registries", LinkConverter.linksToJson(RegistriesConverter.repositoryLinks(baseUri, repository)));
        return json;
    }

    private static List<Link> repositoryLinks(URI baseUri, RegistryRepository repository) {
        ArrayList<Link> registries = new ArrayList<Link>();
        for (String registryName : RegistriesConverter.sortedNamesFrom(repository)) {
            registries.add(repository.get(registryName).asLinkFor(baseUri));
        }
        return registries;
    }

    private static List<String> sortedNamesFrom(RegistryRepository repository) {
        ArrayList<String> registryNames = new ArrayList<String>(repository.getKnownNames());
        Collections.sort(registryNames);
        return registryNames;
    }
}

