/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jsonhome.registry.controller;

import de.otto.jsonhome.annotation.Doc;
import de.otto.jsonhome.annotation.Docs;
import de.otto.jsonhome.annotation.Rel;
import de.otto.jsonhome.registry.controller.RegistriesConverter;
import de.otto.jsonhome.registry.controller.RegistryConverter;
import de.otto.jsonhome.registry.store.Registry;
import de.otto.jsonhome.registry.store.RegistryRepository;
import java.net.URI;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@Docs(value={@Doc(rel="/rel/jsonhome/registries", value={"The collection of known registries:", "<pre><code>{\n      \"self\" : \"http://example.org/registries\",\n      \"registries\" : [\n          {\n              \"href\" : \"http://example.org/registries/live\"\n              \"title\" : \"Home documents of the live environment\",\n          },\n          {\n              \"href\" : \"http://example.org/registries/test\n              \"title\" : \"Home documents of the testing environment\",\n          }\n      ]\n}\n</pre></code>"}), @Doc(rel="/rel/jsonhome/registry", value={"A registry of json-home documents:", "<pre><code>{\n      \"name\" : \"live\",\n      \"title\" : \"Home documents of the live environment\",\n      \"self\" : \"http://example.org/registries/live\",\n      \"container\" : \"http://example.org/registries\",\n      \"service\" : [\n          {\n              \"href\" : \"http://example.org/foo/json-home\"\n              \"title\" : \"Home document of application foo\",\n          },\n          {\n              \"href\" : \"http://example.org/bar/json-home\n              \"title\" : \"Home document of application bar\",\n          }\n      ]\n}\n</pre></code>"})})
public class RegistriesController {
    private static final Logger LOG = LoggerFactory.getLogger(RegistriesController.class);
    private RegistryRepository registryRepository;
    private URI applicationBaseUri;

    @Value(value="${jsonhome.applicationBaseUri}")
    public void setApplicationBaseUri(String baseUri) {
        this.applicationBaseUri = URI.create(baseUri);
        LOG.info("ApplicationbaseUri is {}", (Object)this.applicationBaseUri.toString());
    }

    @Autowired
    public void setRegistryRepository(RegistryRepository registryRepository) {
        this.registryRepository = registryRepository;
    }

    @Rel(value="/rel/jsonhome/registries")
    @RequestMapping(value={"/registries"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, ?> getRegistries(HttpServletResponse response) {
        response.setStatus(200);
        return RegistriesConverter.registriesToJson(this.applicationBaseUri, this.registryRepository);
    }

    @Rel(value="/rel/jsonhome/registry")
    @RequestMapping(value={"/registries/{registryName}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, ?> getRegistry(@PathVariable @Doc(value={"The name of the requested registry."}) String registryName, HttpServletResponse response) {
        Registry registry = this.registryRepository.get(registryName);
        if (registry != null) {
            LOG.info("Returning links containing {} entries.", (Object)registry.getAll().size());
            response.setHeader("Cache-Control", "max-age=3600");
            return RegistryConverter.registryToJson(this.applicationBaseUri, registry);
        }
        LOG.info("Links {} does not exist", (Object)registryName);
        response.setStatus(404);
        return null;
    }

    @Rel(value="/rel/jsonhome/registry")
    @RequestMapping(value={"/registries/{registryName}"}, method={RequestMethod.PUT})
    public void putRegistry(@PathVariable @Doc(value={"The name of registry."}) String registryName, @RequestBody Map<String, Object> registry, HttpServletResponse response) {
        if (this.registryRepository.get(registryName) == null) {
            response.setStatus(201);
        } else {
            response.setStatus(204);
        }
        registry.put("name", registryName);
        this.registryRepository.createOrUpdate(RegistryConverter.jsonToRegistry(registry));
    }

    @Rel(value="/rel/jsonhome/registry")
    @RequestMapping(value={"/registries/{registryName}"}, method={RequestMethod.DELETE})
    public void deleteRegistry(@PathVariable String registryName, HttpServletResponse response) {
        this.registryRepository.delete(registryName);
        response.setStatus(204);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST, reason="Illegal resource format")
    @ExceptionHandler(value={IllegalArgumentException.class, NullPointerException.class})
    public void handleBadRequest() {
    }
}

