/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jsonhome.registry.controller;

import de.otto.jsonhome.registry.store.Link;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LinkConverter {
    private LinkConverter() {
    }

    public static Map<String, String> linkToJson(Link link) {
        LinkedHashMap<String, String> json = new LinkedHashMap<String, String>();
        json.put("href", link.getHref().toString());
        if (!link.getTitle().isEmpty()) {
            json.put("title", link.getTitle());
        }
        return json;
    }

    public static Link jsonToLink(Map<String, String> json) {
        return new Link(URI.create(json.get("href")), json.get("title"));
    }

    public static List<Map<String, String>> linksToJson(Collection<Link> links) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (Link link : links) {
            result.add(LinkConverter.linkToJson(link));
        }
        return result;
    }

    public static List<Link> jsonToLinks(Collection<Map<String, String>> json) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Map<String, String> stringStringMap : json) {
            result.add(LinkConverter.jsonToLink(stringStringMap));
        }
        return result;
    }
}

