/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jsonhome.registry.store;

import java.net.URI;

public final class Link {
    private final String title;
    private final URI href;

    public Link(URI href, String title) {
        if (href == null) {
            throw new NullPointerException("'href' must not be null.");
        }
        if (!href.isAbsolute()) {
            throw new IllegalArgumentException("'href' must be an absolute URI.");
        }
        this.title = title != null ? title : "";
        this.href = href;
    }

    public String getTitle() {
        return this.title;
    }

    public URI getHref() {
        return this.href;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        if (this.href != null ? !this.href.equals(link.href) : link.href != null) {
            return false;
        }
        return !(this.title != null ? !this.title.equals(link.title) : link.title != null);
    }

    public int hashCode() {
        int result = this.title != null ? this.title.hashCode() : 0;
        result = 31 * result + (this.href != null ? this.href.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Link{title='" + this.title + '\'' + ", href=" + this.href + '}';
    }
}

