/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jsonhome.registry.controller;

import de.otto.jsonhome.annotation.Doc;
import de.otto.jsonhome.controller.JsonHomeController;
import de.otto.jsonhome.converter.JsonHomeConverter;
import de.otto.jsonhome.converter.JsonHomeMediaType;
import de.otto.jsonhome.model.JsonHome;
import de.otto.jsonhome.registry.controller.RegistryJsonHomeSource;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RegistryJsonHomeController {
    private static Logger LOG = LoggerFactory.getLogger(JsonHomeController.class);
    private RegistryJsonHomeSource jsonHomeSource;
    private int maxAge = 3600;

    @Autowired
    public void setJsonHomeSource(RegistryJsonHomeSource jsonHomeSource) {
        this.jsonHomeSource = jsonHomeSource;
    }

    public void setMaxAgeSeconds(int maxAge) {
        this.maxAge = maxAge;
        LOG.info("MaxAge is {}", (Object)maxAge);
    }

    @RequestMapping(value={"{registry}/json-home"}, produces={"application/json-home"})
    @ResponseBody
    public Map<String, ?> getAsApplicationJsonHome(@PathVariable @Doc(value={"The name of the json-home registry."}) String registry, HttpServletResponse response) {
        LOG.info("Returning json-home in application/json-home format.");
        response.setHeader("Cache-Control", "max-age=" + this.maxAge);
        response.setHeader("Vary", "Accept");
        return JsonHomeConverter.toRepresentation((JsonHome)this.jsonHomeSource.getJsonHome(registry), (JsonHomeMediaType)JsonHomeMediaType.APPLICATION_JSONHOME);
    }

    @RequestMapping(value={"{registry}/json-home"}, produces={"application/json"})
    @ResponseBody
    public Map<String, ?> getAsApplicationJson(@PathVariable @Doc(value={"The name of the json-home registry."}) String registry, HttpServletResponse response) {
        LOG.info("Returning json-home in application/json format.");
        response.setHeader("Cache-Control", "max-age=" + this.maxAge);
        response.setHeader("Vary", "Accept");
        try {
            return JsonHomeConverter.toRepresentation((JsonHome)this.jsonHomeSource.getJsonHome(registry), (JsonHomeMediaType)JsonHomeMediaType.APPLICATION_JSON);
        }
        catch (IllegalArgumentException e) {
            try {
                response.sendError(404, e.getMessage());
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw e;
        }
    }
}

