/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jsonhome.registry.controller;

import de.otto.jsonhome.client.HttpJsonHomeClient;
import de.otto.jsonhome.client.JsonHomeClient;
import de.otto.jsonhome.client.JsonHomeClientException;
import de.otto.jsonhome.client.NotFoundException;
import de.otto.jsonhome.model.JsonHome;
import de.otto.jsonhome.registry.controller.RegistryJsonHomeSource;
import de.otto.jsonhome.registry.store.Link;
import de.otto.jsonhome.registry.store.RegistryRepository;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultRegistryJsonHomeSource
implements RegistryJsonHomeSource {
    private static Logger LOG = LoggerFactory.getLogger(DefaultRegistryJsonHomeSource.class);
    private final JsonHomeClient client = new HttpJsonHomeClient();
    private RegistryRepository registries;

    @PreDestroy
    public void shutdown() {
        LOG.info("Shutting down JsonHomeClient");
        this.client.shutdown();
    }

    @Autowired
    public void setRegistries(RegistryRepository registries) {
        this.registries = registries;
    }

    @Override
    public JsonHome getJsonHome(String registryName) {
        if (this.registries.get(registryName) == null) {
            String msg = "Links '" + registryName + "' does not exist.";
            LOG.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        HashMap allResourceLinks = new HashMap();
        for (Link link : this.registries.get(registryName).getAll()) {
            try {
                JsonHome jsonHome = this.client.get(link.getHref());
                Map resources = jsonHome.getResources();
                for (URI uri : resources.keySet()) {
                    if (allResourceLinks.containsKey(uri)) {
                        LOG.warn("Duplicate entries found for resource {}: entry '{}', is overridden by '{}'", new Object[]{uri, allResourceLinks.get(uri), resources.get(uri)});
                    }
                    allResourceLinks.put(uri, resources.get(uri));
                }
                allResourceLinks.putAll(resources);
            }
            catch (NotFoundException e) {
                LOG.warn("Unable to get json-home document {}: {}", (Object)link.getHref(), (Object)e.getMessage());
            }
            catch (JsonHomeClientException e) {
                LOG.warn("Unable to get json-home document {}: {}", (Object)link.getHref(), (Object)e.getMessage());
            }
        }
        LOG.debug("Returning json-home instance containing {} relation types: {}", (Object)allResourceLinks.size(), allResourceLinks.keySet());
        return JsonHome.jsonHome(allResourceLinks.values());
    }
}

