/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jsonhome.resource;

import com.sun.jersey.api.view.Viewable;
import de.otto.jsonhome.converter.JsonHomeConverter;
import de.otto.jsonhome.converter.JsonHomeMediaType;
import de.otto.jsonhome.generator.JerseyJsonHomeGenerator;
import de.otto.jsonhome.generator.JsonHomeGenerator;
import de.otto.jsonhome.generator.JsonHomeSource;
import de.otto.jsonhome.model.JsonHome;
import de.otto.jsonhome.resource.JerseyJsonHomeSource;
import de.otto.jsonhome.resource.Responses;
import de.otto.jsonhome.resource.scanner.AnnotationScanner;
import java.io.IOException;
import java.util.HashMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.map.ObjectMapper;

@Path(value="/json-home")
public final class JsonHomeResource {
    private JsonHomeSource jsonHomeSource;
    private int maxAge = 3600;

    public JsonHomeResource(JsonHomeSource jsonHomeSource) {
        this.jsonHomeSource = jsonHomeSource;
    }

    public JsonHomeResource() {
        this.jsonHomeSource = new JerseyJsonHomeSource((JsonHomeGenerator)new JerseyJsonHomeGenerator(), new AnnotationScanner());
    }

    public void setJsonHomeSource(JsonHomeSource jsonHomeSource) {
        this.jsonHomeSource = jsonHomeSource;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    @GET
    @Produces(value={"text/html"})
    public Response getAsTextHtmlHome() {
        HashMap resources = new HashMap();
        resources.put("resources", this.jsonHomeSource.getJsonHome().getResources().values());
        Viewable viewable = new Viewable("/jsonhome/resources", resources);
        return Responses.addCacheControlHeaders(Response.ok((Object)viewable), this.maxAge);
    }

    @GET
    @Produces(value={"application/json-home"})
    public Response getAsApplicationJsonHome() {
        JsonHome jsonHome = this.jsonHomeSource.getJsonHome();
        try {
            return Responses.addCacheControlHeaders(Response.ok((Object)this.toJsonString(jsonHome, JsonHomeMediaType.APPLICATION_JSONHOME)), this.maxAge);
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    public Response getAsApplicationJson() {
        JsonHome jsonHome = this.jsonHomeSource.getJsonHome();
        try {
            return Responses.addCacheControlHeaders(Response.ok((Object)this.toJsonString(jsonHome, JsonHomeMediaType.APPLICATION_JSON)), this.maxAge);
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private String toJsonString(JsonHome jsonHome, JsonHomeMediaType mediaType) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)JsonHomeConverter.toRepresentation((JsonHome)jsonHome, (JsonHomeMediaType)mediaType));
    }
}

