/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jsonhome.resource;

import com.sun.jersey.api.view.Viewable;
import de.otto.jsonhome.generator.JerseyJsonHomeGenerator;
import de.otto.jsonhome.generator.JsonHomeGenerator;
import de.otto.jsonhome.generator.JsonHomeSource;
import de.otto.jsonhome.model.JsonHome;
import de.otto.jsonhome.model.ResourceLink;
import de.otto.jsonhome.resource.JerseyJsonHomeSource;
import de.otto.jsonhome.resource.Responses;
import de.otto.jsonhome.resource.scanner.AnnotationScanner;
import java.util.HashMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/rel/{all:.*}")
public final class RelationResource {
    private final JsonHomeSource jsonHomeSource;
    private int maxAge = 3600;

    public RelationResource(JsonHomeSource jsonHomeSource) {
        this.jsonHomeSource = jsonHomeSource;
    }

    public RelationResource() {
        this.jsonHomeSource = new JerseyJsonHomeSource((JsonHomeGenerator)new JerseyJsonHomeGenerator(), new AnnotationScanner());
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    @GET
    @Produces(value={"text/html"})
    public Response getRelationType(@Context UriInfo uriInfo) {
        HashMap<String, ResourceLink> model = new HashMap<String, ResourceLink>();
        JsonHome jsonHome = this.jsonHomeSource.getJsonHome();
        if (jsonHome.hasResourceFor(uriInfo.getRequestUri())) {
            ResourceLink resourceLink = jsonHome.getResourceFor(uriInfo.getRequestUri());
            model.put("resource", resourceLink);
            Viewable viewable = resourceLink.isDirectLink() ? new Viewable("/jsonhome/directresource", model) : new Viewable("/jsonhome/templatedresource", model);
            return Responses.addCacheControlHeaders(Response.ok((Object)viewable), this.maxAge);
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Unknown relation type " + uriInfo.getRequestUri())).build();
    }
}

