/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jsonhome.generator;

import com.sun.jersey.api.uri.UriBuilderImpl;
import de.otto.jsonhome.generator.HintsGenerator;
import de.otto.jsonhome.generator.HrefVarsGenerator;
import de.otto.jsonhome.generator.HttpMethods;
import de.otto.jsonhome.generator.JerseyHintsGenerator;
import de.otto.jsonhome.generator.JerseyHrefVarsGenerator;
import de.otto.jsonhome.generator.ResourceLinkGenerator;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLDecoder;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriBuilder;

public final class JerseyResourceLinkGenerator
extends ResourceLinkGenerator {
    private final URI applicationBaseUri;

    public JerseyResourceLinkGenerator(URI applicationBaseUri, URI relationTypeBaseUri, URI varTypeBaseUri, String docRootDir) {
        super(applicationBaseUri, relationTypeBaseUri, varTypeBaseUri, (HintsGenerator)new JerseyHintsGenerator(relationTypeBaseUri, docRootDir), (HrefVarsGenerator)new JerseyHrefVarsGenerator(relationTypeBaseUri, docRootDir));
        this.applicationBaseUri = applicationBaseUri;
    }

    protected boolean isCandidateForAnalysis(Method method) {
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            if (!HttpMethods.isHttpMethod(annotation)) continue;
            return true;
        }
        return false;
    }

    protected String resourcePathFor(Method method) {
        if (this.isCandidateForAnalysis(method)) {
            UriBuilder uriBuilder = new UriBuilderImpl().uri(this.applicationBaseUri).path(method.getDeclaringClass());
            if (method.getAnnotation(Path.class) != null) {
                uriBuilder.path(method);
            }
            try {
                return URLDecoder.decode(uriBuilder.build(new Object[0]).toString(), "UTF-8") + this.queryTemplateFrom(method);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }
}

