/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jsonhome.resource.scanner;

import com.google.common.base.Predicate;
import de.otto.jsonhome.JsonHomeProperties;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Path;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public final class AnnotationScanner {
    private final Set<String> packages;

    public AnnotationScanner() {
        String packages = JsonHomeProperties.getProperties().getProperty("resource.packages");
        if (packages == null) {
            throw new IllegalStateException("resource.packages property not set in jsonhome.properties");
        }
        this.packages = new HashSet<String>(Arrays.asList(packages.split("\\s*,\\s*")));
    }

    public AnnotationScanner(Set<String> packages) {
        this.packages = packages;
    }

    public Set<Class<?>> scanClasses() {
        HashSet classes = new HashSet();
        for (String pkg : this.packages) {
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(new URL[]{ClasspathHelper.forClass(Path.class, (ClassLoader[])new ClassLoader[0])}).setScanners(new Scanner[]{new TypeAnnotationsScanner()}).addUrls((Collection)ClasspathHelper.forPackage((String)pkg, (ClassLoader[])new ClassLoader[0])).filterInputsBy((Predicate)new FilterBuilder().include(FilterBuilder.prefix((String)pkg))));
            classes.addAll(reflections.getTypesAnnotatedWith(Path.class));
        }
        return classes;
    }
}

