/*
 * Copyright 2012 Guido Steinacker
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.otto.jsonhome.generator;

import javax.ws.rs.HttpMethod;
import java.lang.annotation.Annotation;

/**
 * @author Sebastian Schroeder
 * @since 09.12.2012
 */
final class HttpMethods {

    private HttpMethods() {}

    public static boolean isHttpMethod(final Annotation annotation) {
        return annotation != null &&
                annotation.annotationType().getAnnotation(HttpMethod.class) != null;
    }

}
