/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jsonhome.generator;

import de.otto.jsonhome.JsonHomeProperties;
import de.otto.jsonhome.generator.JerseyResourceLinkGenerator;
import de.otto.jsonhome.generator.JsonHomeGenerator;
import java.net.URI;
import java.util.Properties;
import javax.ws.rs.Path;

public final class JerseyJsonHomeGenerator
extends JsonHomeGenerator {
    public JerseyJsonHomeGenerator() {
        Properties properties = JsonHomeProperties.getProperties();
        String applicationBaseUri = properties.getProperty("applicationBaseUri");
        if (applicationBaseUri == null) {
            throw new IllegalStateException("applicationBaseUri property not set in jsonhome.properties");
        }
        String relationTypeBaseUri = properties.getProperty("relationTypeBaseUri");
        if (relationTypeBaseUri == null) {
            throw new IllegalStateException("relationTypeBaseUri property not set in jsonhome.properties");
        }
        String varTypeBaseUri = properties.getProperty("varTypeBaseUri", null);
        String docRootDir = properties.getProperty("docRootDir", null);
        this.setResourceLinkGenerator(new JerseyResourceLinkGenerator(URI.create(applicationBaseUri), URI.create(relationTypeBaseUri), varTypeBaseUri != null ? URI.create(varTypeBaseUri) : null, docRootDir));
    }

    JerseyJsonHomeGenerator(URI applicationBaseUri, URI relationTypeBaseUri) {
        this.setResourceLinkGenerator(new JerseyResourceLinkGenerator(applicationBaseUri, relationTypeBaseUri, null, null));
    }

    public JerseyJsonHomeGenerator(String applicationBaseUri, String relationTypeBaseUri) {
        this(URI.create(applicationBaseUri), URI.create(relationTypeBaseUri));
    }

    protected boolean isCandidateForAnalysis(Class<?> resource) {
        return resource.getAnnotation(Path.class) != null;
    }
}

