/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jsonhome.generator;

import de.otto.jsonhome.generator.HintsGenerator;
import de.otto.jsonhome.generator.HttpMethods;
import de.otto.jsonhome.model.Allow;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;

public final class JerseyHintsGenerator
extends HintsGenerator {
    public JerseyHintsGenerator(URI relationTypeBaseUri, String docRootDir) {
        super(relationTypeBaseUri, docRootDir);
    }

    protected Set<Allow> allowedHttpMethodsOf(Method method) {
        Annotation[] annotations = method.getDeclaredAnnotations();
        EnumSet<Allow> allows = EnumSet.noneOf(Allow.class);
        for (Annotation annotation : annotations) {
            if (!HttpMethods.isHttpMethod(annotation)) continue;
            allows.add(Allow.valueOf((String)annotation.annotationType().getSimpleName()));
        }
        return allows;
    }

    protected List<String> producedRepresentationsOf(Method method) {
        Produces produces = method.getAnnotation(Produces.class);
        return produces == null ? Collections.emptyList() : Arrays.asList(produces.value());
    }

    protected List<String> consumedRepresentationsOf(Method method) {
        Consumes consumes = method.getAnnotation(Consumes.class);
        return consumes == null ? Collections.emptyList() : Arrays.asList(consumes.value());
    }
}

