/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.cli;

import com.beust.jcommander.JCommander;
import de.otto.jlineup.JLineupRunner;
import de.otto.jlineup.RunStepConfig;
import de.otto.jlineup.Utils;
import de.otto.jlineup.browser.BrowserUtils;
import de.otto.jlineup.cli.CommandLineParameters;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.exceptions.ConfigValidationException;
import java.io.FileNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Main {
    public static final Logger LOG = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        CommandLineParameters parameters = new CommandLineParameters();
        JCommander jCommander = new JCommander((Object)parameters);
        jCommander.parse(args);
        jCommander.setProgramName("JLineup");
        if (parameters.isHelp()) {
            jCommander.usage();
            LOG.info("Version: {}\n", (Object)Utils.getVersion());
            return;
        }
        if (parameters.isVersion()) {
            LOG.info("JLineup version {}", (Object)Utils.getVersion());
            return;
        }
        if (parameters.isDebug()) {
            Utils.setLogLevelToDebug();
        }
        JobConfig jobConfig = null;
        try {
            jobConfig = Main.buildConfig((CommandLineParameters)parameters);
        }
        catch (FileNotFoundException e) {
            System.exit(1);
        }
        if (parameters.isPrintConfig()) {
            System.out.println(JobConfig.prettyPrint((JobConfig)jobConfig));
            System.exit(0);
        }
        if (jobConfig.debug) {
            Utils.setLogLevelToDebug();
        }
        if (jobConfig.logToFile || parameters.isLogToFile()) {
            Utils.logToFile((String)parameters.getWorkingDirectory());
        }
        LOG.info("Running JLineup [{}] with step '{}'.\n\n", (Object)Utils.getVersion(), (Object)parameters.getStep());
        RunStepConfig runStepConfig = de.otto.jlineup.cli.Utils.convertCommandLineParametersToRunConfiguration((CommandLineParameters)parameters);
        JLineupRunner jLineupRunner = null;
        try {
            jLineupRunner = new JLineupRunner(jobConfig, runStepConfig);
        }
        catch (ConfigValidationException e) {
            LOG.error(e.getMessage());
            System.exit(1);
        }
        try {
            boolean runSucceeded = jLineupRunner.run();
            if (!runSucceeded) {
                System.exit(1);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    private static JobConfig buildConfig(CommandLineParameters parameters) throws FileNotFoundException {
        JobConfig jobConfig;
        if (parameters.getUrl() != null) {
            String url = BrowserUtils.prependHTTPIfNotThereAndToLowerCase((String)parameters.getUrl());
            jobConfig = JobConfig.defaultConfig((String)url);
            if (!parameters.isPrintConfig()) {
                LOG.info("You specified an explicit URL parameter ({}), any given jobConfig file is ignored! This should only be done for testing purpose.%n", (Object)url);
                LOG.info("Using generated jobConfig:%n%s%n", (Object)JobConfig.prettyPrint((JobConfig)jobConfig));
                LOG.info("You can take this generated jobConfig as base and save it as a text file named 'lineup.json'.");
                LOG.info("Just add --print-jobConfig parameter to let JLineup print an example jobConfig");
            }
        } else {
            try {
                jobConfig = de.otto.jlineup.cli.Utils.readConfig((CommandLineParameters)parameters);
            }
            catch (FileNotFoundException e) {
                if (!parameters.isPrintConfig()) {
                    LOG.error(e.getMessage());
                    LOG.error("Use --help to see the JLineup quick help.");
                    throw e;
                }
                return JobConfig.exampleConfig();
            }
        }
        return jobConfig;
    }
}

