/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.BindException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.internal.HttpClientFactory;

public class ApacheHttpClient
implements HttpClient {
    private static final int MAX_REDIRECTS = 10;
    private final URL url;
    private final HttpHost targetHost;
    private final org.apache.http.client.HttpClient client;

    public ApacheHttpClient(org.apache.http.client.HttpClient client, URL url) {
        this.client = Preconditions.checkNotNull(client, "null HttpClient");
        this.url = Preconditions.checkNotNull(url, "null URL");
        String host = url.getHost().replace(".localdomain", "");
        this.targetHost = new HttpHost(host, url.getPort(), url.getProtocol());
    }

    @Override
    public org.openqa.selenium.remote.http.HttpResponse execute(org.openqa.selenium.remote.http.HttpRequest request, boolean followRedirects) throws IOException {
        HttpContext context = this.createContext();
        String requestUrl = this.url.toExternalForm().replaceAll("/$", "") + request.getUri();
        HttpUriRequest httpMethod = ApacheHttpClient.createHttpUriRequest(request.getMethod(), requestUrl);
        for (String name : request.getHeaderNames()) {
            if ("Content-Length".equalsIgnoreCase(name)) continue;
            for (String value : request.getHeaders(name)) {
                httpMethod.addHeader(name, value);
            }
        }
        if (httpMethod instanceof HttpPost) {
            ((HttpPost)httpMethod).setEntity(new ByteArrayEntity(request.getContent()));
        }
        HttpResponse response = this.fallBackExecute(context, httpMethod);
        if (followRedirects) {
            response = this.followRedirects(this.client, context, response, 0);
        }
        return this.createResponse(response, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.openqa.selenium.remote.http.HttpResponse createResponse(HttpResponse response, HttpContext context) throws IOException {
        Object host;
        org.openqa.selenium.remote.http.HttpResponse internalResponse = new org.openqa.selenium.remote.http.HttpResponse();
        internalResponse.setStatus(response.getStatusLine().getStatusCode());
        for (Header header : response.getAllHeaders()) {
            internalResponse.addHeader(header.getName(), header.getValue());
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try {
                internalResponse.setContent(EntityUtils.toByteArray(entity));
            }
            finally {
                EntityUtils.consume(entity);
            }
        }
        if ((host = context.getAttribute("http.target_host")) instanceof HttpHost) {
            internalResponse.setTargetHost(((HttpHost)host).toURI());
        }
        return internalResponse;
    }

    protected HttpContext createContext() {
        return new BasicHttpContext();
    }

    private static HttpUriRequest createHttpUriRequest(HttpMethod method, String url) {
        switch (method) {
            case DELETE: {
                return new HttpDelete(url);
            }
            case GET: {
                return new HttpGet(url);
            }
            case POST: {
                return new HttpPost(url);
            }
        }
        throw new AssertionError((Object)("Unsupported method: " + (Object)((Object)method)));
    }

    private HttpResponse fallBackExecute(HttpContext context, HttpUriRequest httpMethod) throws IOException {
        try {
            return this.client.execute(this.targetHost, (HttpRequest)httpMethod, context);
        }
        catch (BindException e) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        catch (NoHttpResponseException e) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        return this.client.execute(this.targetHost, (HttpRequest)httpMethod, context);
    }

    private HttpResponse followRedirects(org.apache.http.client.HttpClient client, HttpContext context, HttpResponse response, int redirectCount) {
        if (!this.isRedirect(response)) {
            return response;
        }
        try {
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity != null) {
                EntityUtils.consume(httpEntity);
            }
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
        if (redirectCount > 10) {
            throw new WebDriverException("Maximum number of redirects exceeded. Aborting");
        }
        String location = response.getFirstHeader("location").getValue();
        try {
            URI uri = this.buildUri(context, location);
            HttpGet get = new HttpGet(uri);
            get.setHeader("Accept", "application/json; charset=utf-8");
            HttpResponse newResponse = client.execute(this.targetHost, (HttpRequest)get, context);
            return this.followRedirects(client, context, newResponse, redirectCount + 1);
        }
        catch (URISyntaxException e) {
            throw new WebDriverException(e);
        }
        catch (ClientProtocolException e) {
            throw new WebDriverException(e);
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
    }

    private URI buildUri(HttpContext context, String location) throws URISyntaxException {
        URI uri = new URI(location);
        if (!uri.isAbsolute()) {
            HttpHost host = (HttpHost)context.getAttribute("http.target_host");
            uri = new URI(host.toURI() + location);
        }
        return uri;
    }

    private boolean isRedirect(HttpResponse response) {
        int code = response.getStatusLine().getStatusCode();
        return (code == 301 || code == 302 || code == 303 || code == 307) && response.containsHeader("location");
    }

    @Override
    public void close() throws IOException {
        this.client.getConnectionManager().closeIdleConnections(0L, TimeUnit.SECONDS);
    }

    public static class Factory
    implements HttpClient.Factory {
        private static HttpClientFactory defaultClientFactory;
        private final HttpClientFactory clientFactory;

        public Factory() {
            this(Factory.getDefaultHttpClientFactory());
        }

        public Factory(HttpClientFactory clientFactory) {
            this.clientFactory = Preconditions.checkNotNull(clientFactory, "null HttpClientFactory");
        }

        @Override
        public HttpClient createClient(URL url) {
            org.apache.http.client.HttpClient client;
            Preconditions.checkNotNull(url, "null URL");
            if (url.getUserInfo() != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(url.getUserInfo());
                client = this.clientFactory.createHttpClient(credentials);
            } else {
                client = this.clientFactory.getHttpClient();
            }
            return new ApacheHttpClient(client, url);
        }

        private static synchronized HttpClientFactory getDefaultHttpClientFactory() {
            if (defaultClientFactory == null) {
                defaultClientFactory = new HttpClientFactory();
            }
            return defaultClientFactory;
        }
    }
}

