/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions.internal;

import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.Optional;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.IsInteraction;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.internal.BaseAction;
import org.openqa.selenium.internal.Locatable;

public abstract class KeysRelatedAction
extends BaseAction
implements IsInteraction {
    protected final Keyboard keyboard;
    protected final Mouse mouse;

    protected KeysRelatedAction(Keyboard keyboard, Mouse mouse, Locatable locationProvider) {
        super(locationProvider);
        this.keyboard = keyboard;
        this.mouse = mouse;
    }

    protected void focusOnElement() {
        if (this.where != null) {
            this.mouse.click(this.where.getCoordinates());
        }
    }

    protected void optionallyClickElement(PointerInput mouse, ImmutableList.Builder<Interaction> interactions) {
        Optional<WebElement> target = this.getTargetElement();
        if (target.isPresent()) {
            interactions.add((Object)mouse.createPointerMove(Duration.ofMillis(500L), target.map(PointerInput.Origin::fromElement).orElse(PointerInput.Origin.pointer()), 0, 0));
            interactions.add((Object)mouse.createPointerDown(PointerInput.MouseButton.LEFT.asArg()));
            interactions.add((Object)mouse.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
        }
    }
}

