/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.config;

import com.google.gson.annotations.SerializedName;
import de.otto.jlineup.config.Config;
import de.otto.jlineup.config.Cookie;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UrlConfig {
    public final List<String> paths;
    @SerializedName(value="max-diff")
    public final float maxDiff;
    public final List<Cookie> cookies;
    @SerializedName(value="env-mapping")
    public final Map<String, String> envMapping;
    @SerializedName(value="local-storage")
    public final Map<String, String> localStorage;
    @SerializedName(value="session-storage")
    public final Map<String, String> sessionStorage;
    @SerializedName(value="window-widths", alternate={"resolutions", "widths"})
    public final List<Integer> windowWidths;
    @SerializedName(value="max-scroll-height")
    public final int maxScrollHeight;
    @SerializedName(value="wait-after-page-load")
    public final int waitAfterPageLoad;
    @SerializedName(value="wait-after-scroll")
    public final int waitAfterScroll;
    @SerializedName(value="wait-for-no-animation-after-scroll")
    public final float waitForNoAnimationAfterScroll;
    @SerializedName(value="warmup-browser-cache-time")
    public final int warmupBrowserCacheTime;
    @SerializedName(value="wait-for-fonts-time")
    public final int waitForFontsTime;
    @SerializedName(value="javascript")
    public final String javaScript;

    public UrlConfig() {
        this.paths = Config.DEFAULT_PATHS;
        this.windowWidths = Config.DEFAULT_WINDOW_WIDTHS;
        this.maxDiff = 0.0f;
        this.cookies = null;
        this.localStorage = null;
        this.sessionStorage = null;
        this.maxScrollHeight = 100000;
        this.waitAfterPageLoad = 0;
        this.waitAfterScroll = 0;
        this.waitForNoAnimationAfterScroll = 0.0f;
        this.envMapping = null;
        this.warmupBrowserCacheTime = 0;
        this.javaScript = null;
        this.waitForFontsTime = 0;
    }

    public UrlConfig(List<String> paths, float maxDiff, List<Cookie> cookies, Map<String, String> envMapping, Map<String, String> localStorage, Map<String, String> sessionStorage, List<Integer> windowWidths, int maxScrollHeight, int waitAfterPageLoad, int waitAfterScroll, float waitForNoAnimationAfterScroll, int warmupBrowserCacheTime, String javaScript, int waitForFontsTime) {
        this.paths = paths != null ? paths : Config.DEFAULT_PATHS;
        this.windowWidths = windowWidths != null ? windowWidths : Config.DEFAULT_WINDOW_WIDTHS;
        this.maxDiff = maxDiff;
        this.cookies = cookies;
        this.envMapping = envMapping;
        this.localStorage = localStorage;
        this.sessionStorage = sessionStorage;
        this.maxScrollHeight = maxScrollHeight;
        this.waitAfterPageLoad = waitAfterPageLoad;
        this.waitAfterScroll = waitAfterScroll;
        this.waitForNoAnimationAfterScroll = waitForNoAnimationAfterScroll;
        this.warmupBrowserCacheTime = warmupBrowserCacheTime;
        this.javaScript = javaScript;
        this.waitForFontsTime = waitForFontsTime;
    }

    public String toString() {
        return "UrlConfig{paths=" + this.paths + ", maxDiff=" + this.maxDiff + ", cookies=" + this.cookies + ", envMapping=" + this.envMapping + ", localStorage=" + this.localStorage + ", sessionStorage=" + this.sessionStorage + ", windowWidths=" + this.windowWidths + ", maxScrollHeight=" + this.maxScrollHeight + ", waitAfterPageLoad=" + this.waitAfterPageLoad + ", waitAfterScroll=" + this.waitAfterScroll + ", waitForNoAnimationAfterScroll=" + this.waitForNoAnimationAfterScroll + ", warmupBrowserCacheTime=" + this.warmupBrowserCacheTime + ", waitForFontsTime=" + this.waitForFontsTime + ", javaScript='" + this.javaScript + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlConfig urlConfig = (UrlConfig)o;
        return Float.compare(urlConfig.maxDiff, this.maxDiff) == 0 && this.maxScrollHeight == urlConfig.maxScrollHeight && this.waitAfterPageLoad == urlConfig.waitAfterPageLoad && this.waitAfterScroll == urlConfig.waitAfterScroll && Float.compare(urlConfig.waitForNoAnimationAfterScroll, this.waitForNoAnimationAfterScroll) == 0 && this.warmupBrowserCacheTime == urlConfig.warmupBrowserCacheTime && this.waitForFontsTime == urlConfig.waitForFontsTime && Objects.equals(this.paths, urlConfig.paths) && Objects.equals(this.cookies, urlConfig.cookies) && Objects.equals(this.envMapping, urlConfig.envMapping) && Objects.equals(this.localStorage, urlConfig.localStorage) && Objects.equals(this.sessionStorage, urlConfig.sessionStorage) && Objects.equals(this.windowWidths, urlConfig.windowWidths) && Objects.equals(this.javaScript, urlConfig.javaScript);
    }

    public int hashCode() {
        return Objects.hash(this.paths, Float.valueOf(this.maxDiff), this.cookies, this.envMapping, this.localStorage, this.sessionStorage, this.windowWidths, this.maxScrollHeight, this.waitAfterPageLoad, this.waitAfterScroll, Float.valueOf(this.waitForNoAnimationAfterScroll), this.warmupBrowserCacheTime, this.waitForFontsTime, this.javaScript);
    }
}

