/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.browser;

import de.otto.jlineup.config.UrlConfig;

public final class ScreenshotContext {
    public final String url;
    public final String urlSubPath;
    public final int windowWidth;
    public final boolean before;
    public final UrlConfig urlConfig;

    ScreenshotContext(String url, String urlSubPath, int windowWidth, boolean before, UrlConfig urlConfig) {
        this.url = url;
        this.urlSubPath = urlSubPath;
        this.windowWidth = windowWidth;
        this.before = before;
        this.urlConfig = urlConfig;
    }

    public static ScreenshotContext of(String url, String path, int windowWidth, boolean before, UrlConfig urlConfig) {
        return new ScreenshotContext(url, path, windowWidth, before, urlConfig);
    }

    public String toString() {
        return "ScreenshotContext{url='" + this.url + '\'' + ", urlSubPath='" + this.urlSubPath + '\'' + ", windowWidth=" + this.windowWidth + ", before=" + this.before + ", urlConfig=" + this.urlConfig + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreenshotContext that = (ScreenshotContext)o;
        if (this.windowWidth != that.windowWidth) {
            return false;
        }
        if (this.before != that.before) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        if (this.urlSubPath != null ? !this.urlSubPath.equals(that.urlSubPath) : that.urlSubPath != null) {
            return false;
        }
        return this.urlConfig != null ? this.urlConfig.equals(that.urlConfig) : that.urlConfig == null;
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.urlSubPath != null ? this.urlSubPath.hashCode() : 0);
        result = 31 * result + this.windowWidth;
        result = 31 * result + (this.before ? 1 : 0);
        result = 31 * result + (this.urlConfig != null ? this.urlConfig.hashCode() : 0);
        return result;
    }
}

