/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.WdmConfig;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class PhantomJsDriverManager
extends BrowserManager {
    public static synchronized BrowserManager getInstance() {
        if (instance == null || !instance.getClass().equals(PhantomJsDriverManager.class)) {
            instance = new PhantomJsDriverManager();
        }
        return instance;
    }

    @Override
    protected List<URL> getDrivers() throws Exception {
        return this.getDriversFromMirror(this.getDriverUrl());
    }

    @Override
    protected String getExportParameter() {
        return WdmConfig.getString("wdm.phantomjsDriverExport");
    }

    @Override
    protected String getDriverVersionKey() {
        return "wdm.phantomjsDriverVersion";
    }

    @Override
    protected String getDriverUrlKey() {
        return "wdm.phantomjsDriverUrl";
    }

    @Override
    protected List<String> getDriverName() {
        return Arrays.asList("phantomjs");
    }

    @Override
    protected String getCurrentVersion(URL url, String driverName) throws MalformedURLException {
        String file = url.getFile();
        file = url.getFile().substring(file.lastIndexOf("/"), file.length());
        int matchIndex = file.indexOf(driverName);
        String currentVersion = file.substring(matchIndex + driverName.length() + 1, file.length());
        int dashIndex = currentVersion.indexOf(45);
        currentVersion = currentVersion.substring(0, dashIndex);
        return currentVersion;
    }

    @Override
    protected String preDownload(String target, String version) throws IOException {
        int iSeparator = target.indexOf(version) - 1;
        int iDash = target.lastIndexOf(version) + version.length();
        int iPoint = target.lastIndexOf(".tar") != -1 ? target.lastIndexOf(".tar") : target.lastIndexOf(".zip");
        target = target.substring(0, iSeparator + 1) + target.substring(iDash + 1, iPoint) + target.substring(iSeparator);
        target = target.replace("beta-", "");
        return target;
    }

    @Override
    protected File postDownload(File archive) throws IOException {
        log.trace("PhatomJS package name: {}", (Object)archive);
        File extractFolder = archive.getParentFile().listFiles()[0];
        log.trace("PhatomJS extract folder (to be deleted): {}", (Object)extractFolder);
        File binFolder = new File(extractFolder.getAbsoluteFile() + File.separator + "bin");
        int binaryIndex = 0;
        if (!binFolder.exists()) {
            binFolder = extractFolder;
            binaryIndex = 3;
        }
        log.trace("PhatomJS bin folder: {} (index {})", (Object)binFolder, (Object)binaryIndex);
        File phantomjs = binFolder.listFiles()[binaryIndex];
        log.trace("PhatomJS binary: {}", (Object)phantomjs);
        File target = new File(archive.getParentFile().getAbsolutePath() + File.separator + phantomjs.getName());
        log.trace("PhatomJS target: {}", (Object)target);
        phantomjs.renameTo(target);
        FileUtils.deleteDirectory(extractFolder);
        return target;
    }

    @Override
    public BrowserManager useTaobaoMirror() {
        try {
            this.driverUrl = new URL(WdmConfig.getString("wdm.phantomjsDriverTaobaoUrl"));
        }
        catch (MalformedURLException e) {
            log.error("Malformed URL", e);
            throw new RuntimeException(e);
        }
        return instance;
    }

    @Override
    protected boolean shouldCheckArchitecture(String driverName) {
        return false;
    }
}

