/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import com.google.common.io.Files;
import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.WdmConfig;
import io.github.bonigarcia.wdm.WdmHttpClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import org.rauschig.jarchivelib.CompressionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Downloader {
    protected static final Logger log = LoggerFactory.getLogger(Downloader.class);
    private static final String HOME = "~";
    private final BrowserManager browserManager;
    private final WdmHttpClient httpClient;
    private boolean override = WdmConfig.getBoolean("wdm.override");

    public Downloader(BrowserManager browserManager) {
        this(browserManager, new WdmHttpClient.Builder().build());
    }

    public Downloader(BrowserManager browserManager, WdmHttpClient httpClient) {
        this.browserManager = browserManager;
        this.httpClient = httpClient;
    }

    public synchronized void download(URL url, String version, String export, List<String> driverName) throws IOException {
        boolean download;
        File targetFile = new File(this.getTarget(version, url));
        File binary = null;
        boolean bl = download = !targetFile.getParentFile().exists() || targetFile.getParentFile().exists() && targetFile.getParentFile().list().length == 0 || this.override;
        if (!download) {
            Collection<File> listFiles = FileUtils.listFiles(targetFile.getParentFile(), null, true);
            for (File file : listFiles) {
                for (String s : driverName) {
                    if (file.getName().startsWith(s) && file.canExecute()) {
                        binary = file;
                        log.debug("Using binary driver previously downloaded {}", (Object)binary);
                        download = false;
                        break;
                    }
                    download = true;
                }
                if (download) continue;
                break;
            }
        }
        if (download) {
            log.info("Downloading {} to {}", (Object)url, (Object)targetFile);
            WdmHttpClient.Get get = new WdmHttpClient.Get(url).addHeader("User-Agent", "Mozilla/5.0").addHeader("Connection", "keep-alive");
            FileUtils.copyInputStreamToFile(this.httpClient.execute(get).getContent(), targetFile);
            binary = !export.contains("edge") ? this.extract(targetFile, export) : targetFile;
        }
        if (export != null) {
            BrowserManager.exportDriver(export, binary.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File extractMsi(File msi) throws IOException {
        File tmpMsi = new File(Files.createTempDir().getAbsoluteFile() + File.separator + msi.getName());
        Files.move(msi, tmpMsi);
        log.trace("Temporal msi file: {}", (Object)tmpMsi);
        Process process = Runtime.getRuntime().exec(new String[]{"msiexec", "/a", tmpMsi.toString(), "/qb", "TARGETDIR=" + msi.getParent()});
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            log.error("Exception waiting to msiexec to be finished", e);
        }
        finally {
            process.destroy();
        }
        tmpMsi.delete();
        Collection<File> listFiles = FileUtils.listFiles(new File(msi.getParent()), new String[]{"exe"}, true);
        return listFiles.iterator().next();
    }

    public File extract(File compressedFile, String export) throws IOException {
        log.trace("Compressed file {}", (Object)compressedFile);
        File file = null;
        file = compressedFile.getName().toLowerCase().endsWith("tar.bz2") ? this.unBZip2(compressedFile) : (compressedFile.getName().toLowerCase().endsWith("tar.gz") ? this.unTarGz(compressedFile) : (compressedFile.getName().toLowerCase().endsWith("gz") ? this.unGzip(compressedFile) : this.unZip(compressedFile)));
        compressedFile.delete();
        file = this.browserManager.postDownload(compressedFile);
        File result = file.getAbsoluteFile();
        result.setExecutable(true);
        log.trace("Resulting binary file {}", (Object)result);
        return result;
    }

    public File unZip(File compressedFile) throws IOException {
        File file = null;
        ZipFile zipFolder = new ZipFile(compressedFile);
        Enumeration<? extends ZipEntry> enu = zipFolder.entries();
        while (enu.hasMoreElements()) {
            ZipEntry zipEntry = enu.nextElement();
            String name = zipEntry.getName();
            long size = zipEntry.getSize();
            long compressedSize = zipEntry.getCompressedSize();
            log.trace("Unzipping {} (size: {} KB, compressed size: {} KB)", name, size, compressedSize);
            file = new File(compressedFile.getParentFile() + File.separator + name);
            if (!file.exists() || this.override) {
                int length;
                if (name.endsWith("/")) {
                    file.mkdirs();
                    continue;
                }
                File parent = file.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                InputStream is = zipFolder.getInputStream(zipEntry);
                FileOutputStream fos = new FileOutputStream(file);
                byte[] bytes = new byte[1024];
                while ((length = is.read(bytes)) >= 0) {
                    fos.write(bytes, 0, length);
                }
                is.close();
                fos.close();
                file.setExecutable(true);
                continue;
            }
            log.debug(file + " already exists");
        }
        zipFolder.close();
        return file;
    }

    public File unGzip(File archive) throws IOException {
        int iDot;
        log.trace("UnGzip {}", (Object)archive);
        String fileName = archive.getName();
        int iDash = fileName.indexOf("-");
        if (iDash != -1) {
            fileName = fileName.substring(0, iDash);
        }
        if ((iDot = fileName.indexOf(".")) != -1) {
            fileName = fileName.substring(0, iDot);
        }
        File target = new File(archive.getParentFile() + File.separator + fileName);
        try (GZIPInputStream in = new GZIPInputStream(new FileInputStream(archive));
             FileOutputStream out = new FileOutputStream(target);){
            int c = in.read();
            while (c != -1) {
                out.write(c);
                c = in.read();
            }
        }
        if (!target.getName().toLowerCase().contains(".exe") && target.exists()) {
            target.setExecutable(true);
        }
        return target;
    }

    public File unTarGz(File archive) throws IOException {
        Archiver archiver = ArchiverFactory.createArchiver(ArchiveFormat.TAR, CompressionType.GZIP);
        archiver.extract(archive, archive.getParentFile());
        log.trace("unTarGz {}", (Object)archive);
        return archive;
    }

    public File unBZip2(File archive) throws IOException {
        Archiver archiver = ArchiverFactory.createArchiver(ArchiveFormat.TAR, CompressionType.BZIP2);
        archiver.extract(archive, archive.getParentFile());
        log.trace("Unbzip2 {}", (Object)archive);
        return archive;
    }

    public String getTarget(String version, URL url) throws IOException {
        log.trace("getTarget {} {}", (Object)version, (Object)url);
        String zip = url.getFile().substring(url.getFile().lastIndexOf("/"));
        int iFirst = zip.indexOf("_");
        int iSecond = zip.indexOf("-");
        int iLast = iFirst != zip.lastIndexOf("_") ? zip.lastIndexOf("_") : (iSecond != -1 ? iSecond : zip.length());
        String folder = zip.substring(0, iLast).replace(".zip", "").replace(".tar.bz2", "").replace(".tar.gz", "").replace(".msi", "").replace(".exe", "").replace("_", File.separator);
        String target = this.browserManager.preDownload(this.getTargetPath() + folder + File.separator + version + zip, version);
        log.trace("Target file for URL {} version {} = {}", url, version, target);
        return target;
    }

    public String getTargetPath() {
        File repository;
        String targetPath = WdmConfig.getString("wdm.targetPath");
        if (targetPath.contains(HOME)) {
            targetPath = targetPath.replace(HOME, System.getProperty("user.home"));
        }
        if (!(repository = new File(targetPath)).exists()) {
            repository.mkdirs();
        }
        return targetPath;
    }

    public void forceDownload() {
        this.override = true;
    }
}

