/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.WdmConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class ChromeDriverManager
extends BrowserManager {
    public static synchronized BrowserManager getInstance() {
        if (instance == null || !instance.getClass().equals(ChromeDriverManager.class)) {
            instance = new ChromeDriverManager();
        }
        return instance;
    }

    @Override
    protected List<URL> getDrivers() throws Exception {
        URL driverUrl = this.getDriverUrl();
        List<URL> urls = this.isUsingTaobaoMirror() ? this.getDriversFromMirror(driverUrl) : this.getDriversFromXml(this.getDriverUrl(), this.getDriverName());
        return urls;
    }

    @Override
    protected String getExportParameter() {
        return WdmConfig.getString("wdm.chromeDriverExport");
    }

    @Override
    protected String getDriverVersionKey() {
        return "wdm.chromeDriverVersion";
    }

    @Override
    protected String getDriverUrlKey() {
        return "wdm.chromeDriverUrl";
    }

    @Override
    protected List<String> getDriverName() {
        return Arrays.asList("chromedriver");
    }

    @Override
    protected String getCurrentVersion(URL url, String driverName) throws MalformedURLException {
        if (this.isUsingTaobaoMirror()) {
            int i = url.getFile().lastIndexOf("/");
            int j = url.getFile().substring(0, i).lastIndexOf("/") + 1;
            return url.getFile().substring(j, i);
        }
        return super.getCurrentVersion(url, driverName);
    }

    @Override
    public BrowserManager useTaobaoMirror() {
        try {
            this.driverUrl = new URL(WdmConfig.getString("wdm.chromeDriverTaobaoUrl"));
        }
        catch (MalformedURLException e) {
            log.error("Malformed URL", e);
            throw new RuntimeException(e);
        }
        return instance;
    }
}

