/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.config;

import java.util.Date;

public class Cookie {
    public final String name;
    public final String value;
    public final String domain;
    public final String path;
    public final Date expiry;
    public final boolean secure;

    public Cookie(String name, String value, String domain, String path, Date expiry, boolean secure) {
        this.name = name;
        this.value = value;
        this.domain = domain;
        this.path = path;
        this.expiry = expiry;
        this.secure = secure;
    }

    public Cookie(String name, String value) {
        this.name = name;
        this.value = value;
        this.domain = null;
        this.path = null;
        this.expiry = null;
        this.secure = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cookie cookie = (Cookie)o;
        if (this.secure != cookie.secure) {
            return false;
        }
        if (this.name != null ? !this.name.equals(cookie.name) : cookie.name != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(cookie.value) : cookie.value != null) {
            return false;
        }
        if (this.domain != null ? !this.domain.equals(cookie.domain) : cookie.domain != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(cookie.path) : cookie.path != null) {
            return false;
        }
        return this.expiry != null ? this.expiry.equals(cookie.expiry) : cookie.expiry == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.expiry != null ? this.expiry.hashCode() : 0);
        result = 31 * result + (this.secure ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Cookie{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", domain='" + this.domain + '\'' + ", path='" + this.path + '\'' + ", expiry=" + this.expiry + ", secure=" + this.secure + '}';
    }
}

