/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.browser;

import de.otto.jlineup.Util;
import de.otto.jlineup.browser.BrowserUtils;
import de.otto.jlineup.browser.ScreenshotContext;
import de.otto.jlineup.config.Config;
import de.otto.jlineup.config.Cookie;
import de.otto.jlineup.config.Parameters;
import de.otto.jlineup.file.FileService;
import de.otto.jlineup.image.ImageService;
import java.awt.AWTException;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Browser
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(Browser.class);
    public static final int THREADPOOL_SUBMIT_SHUFFLE_TIME_IN_MS = 233;
    public static final int DEFAULT_SLEEP_AFTER_SCROLL_MILLIS = 50;
    static final String JS_DOCUMENT_HEIGHT_CALL = "return Math.max( document.body.scrollHeight, document.body.offsetHeight, document.documentElement.clientHeight, document.documentElement.scrollHeight, document.documentElement.offsetHeight );";
    static final String JS_CLIENT_VIEWPORT_HEIGHT_CALL = "return document.documentElement.clientHeight";
    static final String JS_SET_LOCAL_STORAGE_CALL = "localStorage.setItem('%s','%s')";
    static final String JS_SET_SESSION_STORAGE_CALL = "sessionStorage.setItem('%s','%s')";
    static final String JS_SCROLL_CALL = "window.scrollBy(0,%d)";
    static final String JS_SCROLL_TO_TOP_CALL = "window.scrollTo(0, 0);";
    static final String JS_RETURN_DOCUMENT_FONTS_SIZE_CALL = "return document.fonts.size;";
    static final String JS_RETURN_DOCUMENT_FONTS_STATUS_LOADED_CALL = "return document.fonts.status === 'loaded';";
    static final String JS_GET_BROWSER_AND_VERSION_CALL = "function get_browser() {\n    var ua=navigator.userAgent,tem,M=ua.match(/(opera|chrome|safari|firefox|msie|trident(?=\\/))\\/?\\s*(\\d+)/i) || []; \n    if(/trident/i.test(M[1])){\n        tem=/\\brv[ :]+(\\d+)/g.exec(ua) || []; \n        return {name:'IE',version:(tem[1]||'')};\n        }   \n    if(M[1]==='Chrome'){\n        tem=ua.match(/\\bOPR|Edge\\/(\\d+)/)\n        if(tem!=null)   {return {name:'Opera', version:tem[1]};}\n        }   \n    M=M[2]? [M[1], M[2]]: [navigator.appName, navigator.appVersion, '-?'];\n    if((tem=ua.match(/version\\/(\\d+)/i))!=null) {M.splice(1,1,tem[1]);}\n    return {\n      name: M[0],\n      version: M[1]\n    };\n }\n\nreturn get_browser();\n";
    static final String JS_GET_USER_AGENT = "return navigator.appVersion;";
    private final Parameters parameters;
    private final Config config;
    private final FileService fileService;
    private final BrowserUtils browserUtils;
    private ExecutorService threadPool;
    private ConcurrentHashMap<String, WebDriver> webDrivers = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Set<String>> cacheWarmupMarksMap = new ConcurrentHashMap();
    private AtomicBoolean printVersion = new AtomicBoolean(true);
    private ExpectedCondition<Boolean> fontsLoaded = driver -> {
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)((Object)this.getWebDriver());
        Long fontsLoadedCount = (Long)javascriptExecutor.executeScript(JS_RETURN_DOCUMENT_FONTS_SIZE_CALL, new Object[0]);
        Boolean fontsLoaded = (Boolean)javascriptExecutor.executeScript(JS_RETURN_DOCUMENT_FONTS_STATUS_LOADED_CALL, new Object[0]);
        LOG.debug("Amount of fonts in document: {}", (Object)fontsLoadedCount);
        LOG.debug("Fonts loaded: {} ", (Object)fontsLoaded);
        return fontsLoaded;
    };

    public Browser(Parameters parameters, Config config, FileService fileService, BrowserUtils browserUtils) {
        this.parameters = parameters;
        this.config = config;
        this.fileService = fileService;
        this.browserUtils = browserUtils;
        this.threadPool = Util.createThreadPool(config.threads, "BrowserThread");
    }

    @Override
    public void close() throws Exception {
        this.webDrivers.values().forEach(WebDriver::close);
        this.webDrivers.values().forEach(WebDriver::quit);
        this.webDrivers.clear();
    }

    public void takeScreenshots() throws IOException, InterruptedException, ExecutionException {
        boolean before = !this.parameters.isAfter();
        List<ScreenshotContext> screenshotContextList = BrowserUtils.buildScreenshotContextListFromConfigAndState(this.parameters, this.config, before);
        if (screenshotContextList.size() > 0) {
            this.takeScreenshots(screenshotContextList);
        }
    }

    void takeScreenshots(List<ScreenshotContext> screenshotContextList) throws InterruptedException, ExecutionException {
        ArrayList screenshotResults = new ArrayList();
        for (ScreenshotContext screenshotContext : screenshotContextList) {
            Future<?> takeScreenshotsResult = this.threadPool.submit(() -> {
                try {
                    this.takeScreenshotsForContext(screenshotContext);
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    this.threadPool.shutdownNow();
                    throw new WebDriverException("Exception in Browser thread", e);
                }
                catch (Exception other) {
                    other.printStackTrace();
                    this.threadPool.shutdownNow();
                    throw other;
                }
            });
            screenshotResults.add(takeScreenshotsResult);
            Thread.sleep(233L);
        }
        this.threadPool.shutdown();
        this.threadPool.awaitTermination(15L, TimeUnit.MINUTES);
        for (Future future : screenshotResults) {
            future.get();
        }
    }

    private void takeScreenshotsForContext(ScreenshotContext screenshotContext) throws InterruptedException, IOException, WebDriverException {
        WebDriver localDriver = this.getWebDriver();
        if (this.printVersion.getAndSet(false)) {
            System.out.println("\n\n====================================================\nUser agent: " + this.getBrowserAndVersion() + "\n====================================================\n\n");
        }
        if (this.config.browser != Type.PHANTOMJS) {
            this.moveMouseToZeroZero();
        }
        localDriver.manage().window().setPosition(new Point(0, 0));
        this.resizeBrowser(localDriver, screenshotContext.windowWidth, this.config.windowHeight);
        String url = BrowserUtils.buildUrl(screenshotContext.url, screenshotContext.urlSubPath, screenshotContext.urlConfig.envMapping);
        String rootUrl = BrowserUtils.buildUrl(screenshotContext.url, "/", screenshotContext.urlConfig.envMapping);
        if (this.areThereCookiesOrStorage(screenshotContext)) {
            LOG.info(String.format("Getting root url: %s to set cookies, local and session storage", rootUrl));
            localDriver.get(rootUrl);
            this.setCookies(screenshotContext);
            this.setLocalStorage(screenshotContext);
            this.setSessionStorage(screenshotContext);
        }
        this.checkBrowserCacheWarmup(screenshotContext, url, localDriver);
        LOG.info(String.format("Browsing to %s with window size %dx%d", url, screenshotContext.windowWidth, this.config.windowHeight));
        localDriver.get(url);
        Long pageHeight = this.getPageHeight();
        Long viewportHeight = this.getViewportHeight();
        if (screenshotContext.urlConfig.waitAfterPageLoad > 0) {
            try {
                LOG.debug(String.format("Waiting for %d seconds (wait-after-page-load)", screenshotContext.urlConfig.waitAfterPageLoad));
                Thread.sleep(screenshotContext.urlConfig.waitAfterPageLoad * 1000);
            }
            catch (InterruptedException e) {
                LOG.error(e.getMessage(), e);
            }
        }
        if (this.config.globalWaitAfterPageLoad.floatValue() > 0.0f) {
            LOG.debug(String.format("Waiting for %s seconds (global wait-after-page-load)", this.config.globalWaitAfterPageLoad));
            Thread.sleep(Math.round(this.config.globalWaitAfterPageLoad.floatValue() * 1000.0f));
        }
        LOG.debug("Page height before scrolling: {}", (Object)pageHeight);
        LOG.debug("Viewport height of browser window: {}", (Object)viewportHeight);
        this.scrollToTop();
        this.executeJavaScript(screenshotContext.urlConfig.javaScript);
        if (screenshotContext.urlConfig.waitForFontsTime > 0) {
            if (this.config.browser != Type.PHANTOMJS) {
                WebDriverWait wait = new WebDriverWait(this.getWebDriver(), screenshotContext.urlConfig.waitForFontsTime);
                wait.until(this.fontsLoaded);
            } else {
                System.out.println("WARNING: 'wait-for-fonts-time' is ignored because PhantomJS doesn't support this feature.");
            }
        }
        int yPosition = 0;
        while ((long)yPosition < pageHeight && yPosition <= screenshotContext.urlConfig.maxScrollHeight) {
            BufferedImage currentScreenshot = this.takeScreenshot();
            currentScreenshot = this.waitForNoAnimation(screenshotContext, currentScreenshot);
            this.fileService.writeScreenshot(currentScreenshot, screenshotContext.url, screenshotContext.urlSubPath, screenshotContext.windowWidth, yPosition, screenshotContext.before ? "before" : "after");
            if (this.config.browser == Type.PHANTOMJS) break;
            LOG.debug("topOfViewport: {}, pageHeight: {}", (Object)yPosition, (Object)pageHeight);
            LOG.debug("Scroll by {}", (Object)viewportHeight.intValue());
            this.scrollBy(viewportHeight.intValue());
            LOG.debug("Scroll by {} done", (Object)viewportHeight.intValue());
            if (screenshotContext.urlConfig.waitAfterScroll > 0) {
                LOG.debug("Waiting for {} seconds (wait after scroll).", (Object)screenshotContext.urlConfig.waitAfterScroll);
                TimeUnit.SECONDS.sleep(screenshotContext.urlConfig.waitAfterScroll);
            }
            LOG.debug("Getting page height.");
            pageHeight = this.getPageHeight();
            LOG.debug("Page height is {}", (Object)pageHeight);
            yPosition = (int)((long)yPosition + viewportHeight);
        }
    }

    private void resizeBrowser(WebDriver localDriver, int width, int height) {
        LOG.debug("Resize browser window to {}x{}", (Object)width, (Object)height);
        localDriver.manage().window().setSize(new Dimension(width + 1, height + 1));
        localDriver.manage().window().setSize(new Dimension(width, height));
    }

    private WebDriver initializeWebDriver() {
        WebDriver driver = this.browserUtils.getWebDriverByConfig(this.config);
        driver.manage().timeouts().implicitlyWait(60L, TimeUnit.SECONDS);
        return driver;
    }

    private Set<String> initializeCacheWarmupMarks() {
        return new HashSet<String>();
    }

    private boolean areThereCookiesOrStorage(ScreenshotContext screenshotContext) {
        return screenshotContext.urlConfig.cookies != null && screenshotContext.urlConfig.cookies.size() > 0 || screenshotContext.urlConfig.localStorage != null && screenshotContext.urlConfig.localStorage.size() > 0 || screenshotContext.urlConfig.sessionStorage != null && screenshotContext.urlConfig.sessionStorage.size() > 0;
    }

    private void setCookies(ScreenshotContext screenshotContext) {
        if (this.config.browser == Type.PHANTOMJS) {
            LOG.debug("Setting cookies for PhantomJS");
            this.setCookiesPhantomJS(screenshotContext.urlConfig.cookies);
        } else {
            LOG.debug("Setting cookies");
            this.setCookies(screenshotContext.urlConfig.cookies);
        }
    }

    private void checkBrowserCacheWarmup(ScreenshotContext screenshotContext, String url, WebDriver driver) {
        Set browserCacheWarmupMarks;
        int warmupTime = screenshotContext.urlConfig.warmupBrowserCacheTime;
        if (warmupTime > 0 && !(browserCacheWarmupMarks = this.cacheWarmupMarksMap.computeIfAbsent(Thread.currentThread().getName(), k -> this.initializeCacheWarmupMarks())).contains(url)) {
            Integer maxWidth = (Integer)screenshotContext.urlConfig.windowWidths.stream().max(Integer::compareTo).get();
            LOG.info(String.format("Browsing to %s with window size %dx%d for cache warmup", url, maxWidth, this.config.windowHeight));
            this.resizeBrowser(driver, maxWidth, this.config.windowHeight);
            LOG.debug("Getting url: {}", (Object)url);
            driver.get(url);
            LOG.debug(String.format("First call of %s - waiting %d seconds for cache warmup", url, warmupTime));
            browserCacheWarmupMarks.add(url);
            try {
                LOG.debug("Sleeping for {} seconds", (Object)warmupTime);
                Thread.sleep(warmupTime * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.resizeBrowser(driver, screenshotContext.windowWidth, this.config.windowHeight);
            LOG.debug("Cache warmup time is over. Getting " + url + " again.");
        }
    }

    private BufferedImage takeScreenshot() throws IOException {
        File screenshot = ((TakesScreenshot)((Object)this.getWebDriver())).getScreenshotAs(OutputType.FILE);
        return ImageIO.read(screenshot);
    }

    private BufferedImage waitForNoAnimation(ScreenshotContext screenshotContext, BufferedImage currentScreenshot) throws IOException {
        float waitForNoAnimation = screenshotContext.urlConfig.waitForNoAnimationAfterScroll;
        if (waitForNoAnimation > 0.0f) {
            long beginTime = System.currentTimeMillis();
            int sameCounter = 0;
            while (sameCounter < 10 && !this.timeIsOver(beginTime, waitForNoAnimation)) {
                File screenshot = ((TakesScreenshot)((Object)this.getWebDriver())).getScreenshotAs(OutputType.FILE);
                BufferedImage newScreenshot = ImageIO.read(screenshot);
                if (ImageService.bufferedImagesEqualQuick(newScreenshot, currentScreenshot)) {
                    ++sameCounter;
                }
                currentScreenshot = newScreenshot;
            }
        }
        return currentScreenshot;
    }

    private boolean timeIsOver(long beginTime, float waitForNoAnimation) {
        boolean over;
        boolean bl = over = beginTime + (long)(waitForNoAnimation * 1000.0f) < System.currentTimeMillis();
        if (over) {
            LOG.debug("Time is over");
        }
        return over;
    }

    private Long getPageHeight() {
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.getWebDriver());
        return (Long)jse.executeScript(JS_DOCUMENT_HEIGHT_CALL, new Object[0]);
    }

    private Long getViewportHeight() {
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.getWebDriver());
        return (Long)jse.executeScript(JS_CLIENT_VIEWPORT_HEIGHT_CALL, new Object[0]);
    }

    private void executeJavaScript(String javaScript) throws InterruptedException {
        if (javaScript == null) {
            return;
        }
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.getWebDriver());
        jse.executeScript(javaScript, new Object[0]);
        Thread.sleep(50L);
    }

    private String getBrowserAndVersion() {
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.getWebDriver());
        return (String)jse.executeScript(JS_GET_USER_AGENT, new Object[0]);
    }

    void scrollBy(int viewportHeight) throws InterruptedException {
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.getWebDriver());
        jse.executeScript(String.format(JS_SCROLL_CALL, viewportHeight), new Object[0]);
        Thread.sleep(50L);
    }

    private void scrollToTop() throws InterruptedException {
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.getWebDriver());
        jse.executeScript(JS_SCROLL_TO_TOP_CALL, new Object[0]);
        Thread.sleep(50L);
    }

    private void setLocalStorage(ScreenshotContext screenshotContext) {
        this.setLocalStorage(screenshotContext.urlConfig.localStorage);
    }

    private void setSessionStorage(ScreenshotContext screenshotContext) {
        this.setSessionStorage(screenshotContext.urlConfig.sessionStorage);
    }

    void setLocalStorage(Map<String, String> localStorage) {
        if (localStorage == null) {
            return;
        }
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.getWebDriver());
        for (Map.Entry<String, String> localStorageEntry : localStorage.entrySet()) {
            String entry = localStorageEntry.getValue().replace("'", "\"");
            String jsCall = String.format(JS_SET_LOCAL_STORAGE_CALL, localStorageEntry.getKey(), entry);
            jse.executeScript(jsCall, new Object[0]);
            LOG.debug("LocalStorage call: {}", (Object)jsCall);
        }
    }

    void setSessionStorage(Map<String, String> sessionStorage) {
        if (sessionStorage == null) {
            return;
        }
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.getWebDriver());
        for (Map.Entry<String, String> sessionStorageEntry : sessionStorage.entrySet()) {
            String entry = sessionStorageEntry.getValue().replace("'", "\"");
            String jsCall = String.format(JS_SET_SESSION_STORAGE_CALL, sessionStorageEntry.getKey(), entry);
            jse.executeScript(jsCall, new Object[0]);
            LOG.debug("SessionStorage call: {}", (Object)jsCall);
        }
    }

    void setCookies(List<Cookie> cookies) {
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            Cookie.Builder cookieBuilder = new Cookie.Builder(cookie.name, cookie.value);
            if (cookie.domain != null) {
                cookieBuilder.domain(cookie.domain);
            }
            if (cookie.path != null) {
                cookieBuilder.path(cookie.path);
            }
            if (cookie.expiry != null) {
                cookieBuilder.expiresOn(cookie.expiry);
            }
            cookieBuilder.isSecure(cookie.secure);
            this.getWebDriver().manage().addCookie(cookieBuilder.build());
        }
    }

    void setCookiesPhantomJS(List<Cookie> cookies) {
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            StringBuilder cookieCallBuilder = new StringBuilder(String.format("document.cookie = '%s=%s;", cookie.name, cookie.value));
            if (cookie.path != null) {
                cookieCallBuilder.append("path=");
                cookieCallBuilder.append(cookie.path);
                cookieCallBuilder.append(";");
            }
            if (cookie.domain != null) {
                cookieCallBuilder.append("domain=");
                cookieCallBuilder.append(cookie.domain);
                cookieCallBuilder.append(";");
            }
            if (cookie.secure) {
                cookieCallBuilder.append("secure;");
            }
            if (cookie.expiry != null) {
                cookieCallBuilder.append("expires=");
                SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", Locale.US);
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                String asGmt = df.format(cookie.expiry.getTime()) + " GMT";
                cookieCallBuilder.append(asGmt);
                cookieCallBuilder.append(";");
            }
            cookieCallBuilder.append("'");
            ((JavascriptExecutor)((Object)this.getWebDriver())).executeScript(cookieCallBuilder.toString(), new Object[0]);
        }
    }

    private WebDriver getWebDriver() {
        return this.webDrivers.computeIfAbsent(Thread.currentThread().getName(), k -> this.initializeWebDriver());
    }

    private void moveMouseToZeroZero() {
        try {
            Robot robot = new Robot();
            robot.mouseMove(0, 0);
        }
        catch (AWTException e) {
            LOG.error("Can't move mouse to 0,0", e);
        }
    }

    public static enum Type {
        FIREFOX,
        CHROME,
        PHANTOMJS;

    }
}

