/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.beust.jcommander.JCommander;
import com.google.gson.GsonBuilder;
import de.otto.jlineup.Util;
import de.otto.jlineup.browser.Browser;
import de.otto.jlineup.browser.BrowserUtils;
import de.otto.jlineup.config.Config;
import de.otto.jlineup.config.Parameters;
import de.otto.jlineup.file.FileService;
import de.otto.jlineup.image.ImageService;
import de.otto.jlineup.report.HTMLReportWriter;
import de.otto.jlineup.report.JSONReportWriter;
import de.otto.jlineup.report.JSONReportWriter_V1;
import de.otto.jlineup.report.JSONReportWriter_V2;
import de.otto.jlineup.report.Report;
import de.otto.jlineup.report.ReportGenerator;
import de.otto.jlineup.report.ScreenshotComparisonResult;
import de.otto.jlineup.report.ScreenshotsComparator;
import de.otto.jlineup.report.UrlReport;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.LoggerFactory;

public class Main {
    public static void main(String[] args) throws Exception {
        Config config;
        Parameters parameters = new Parameters();
        JCommander jCommander = new JCommander((Object)parameters, args);
        jCommander.setProgramName("JLineup");
        if (parameters.isHelp()) {
            jCommander.usage();
            System.out.printf("Version: %s%n", Main.getVersion());
            return;
        }
        if (parameters.isVersion()) {
            System.out.printf("JLineup version %s", Main.getVersion());
            return;
        }
        if (parameters.isDebug()) {
            Main.setLogLevelToDebug();
        }
        FileService fileService = new FileService(parameters);
        ImageService imageService = new ImageService();
        if (parameters.isBefore()) {
            fileService.createWorkingDirectoryIfNotExists();
        }
        boolean exit = false;
        if (parameters.getUrl() != null) {
            String url = BrowserUtils.prependHTTPIfNotThereAndToLowerCase(parameters.getUrl());
            config = Config.defaultConfig(url);
            if (!parameters.isPrintConfig()) {
                System.out.printf("You specified an explicit URL parameter (%s), any given config file is ignored! This should only be done for testing purpose.%n", url);
                System.out.printf("Using generated config:%n%s%n", Main.createPrettyConfigJson(config));
                System.out.println("You can take this generated config as base and save it as a text file named 'lineup.json'.");
                System.out.println("Just add --print-config parameter to let JLineup print an example config");
            }
        } else {
            try {
                config = Config.readConfig(parameters);
            }
            catch (FileNotFoundException e) {
                if (!parameters.isPrintConfig()) {
                    System.err.println(e.getMessage());
                    System.err.println("Use --help to see the JLineup quick help.");
                }
                config = Config.exampleConfig();
                exit = true;
            }
        }
        if (parameters.isPrintConfig()) {
            System.out.println(Main.createPrettyConfigJson(config));
            System.exit(0);
        }
        if (exit) {
            System.exit(1);
        }
        if (config.debug) {
            Main.setLogLevelToDebug();
        }
        if (parameters.isBefore()) {
            fileService.createOrClearReportDirectory();
            fileService.createOrClearScreenshotsDirectory();
        }
        System.out.printf("Running JLineup [%s] with step '%s'.%n%n", new Object[]{Main.getVersion(), parameters.getStep()});
        if (!parameters.isJustCompare()) {
            BrowserUtils browserUtils = new BrowserUtils();
            try (Browser browser = new Browser(parameters, config, fileService, browserUtils);){
                browser.takeScreenshots();
            }
            catch (Exception e) {
                System.err.println("JLineup Exception: " + e);
                System.exit(1);
            }
        }
        if (parameters.isAfter() || parameters.isJustCompare()) {
            ScreenshotsComparator screenshotsComparator = new ScreenshotsComparator(parameters, config, fileService, imageService);
            Map<String, List<ScreenshotComparisonResult>> comparisonResults = screenshotsComparator.compare();
            ReportGenerator reportGenerator = new ReportGenerator();
            Report report = reportGenerator.generateReport(comparisonResults);
            JSONReportWriter jsonReportWriter = Main.useLegacyReportFormat(config) ? new JSONReportWriter_V1(fileService) : new JSONReportWriter_V2(fileService);
            jsonReportWriter.writeComparisonReportAsJson(report);
            HTMLReportWriter htmlReportWriter = new HTMLReportWriter(fileService);
            htmlReportWriter.writeReport(report);
            Set<Map.Entry<String, UrlReport>> entries = report.screenshotComparisonsForUrl.entrySet();
            for (Map.Entry<String, UrlReport> entry : entries) {
                System.out.println("Sum of screenshot differences for " + entry.getKey() + ":\n" + entry.getValue().summary.differenceSum + " (" + Math.round(report.summary.differenceSum * 100.0) + " %)");
                System.out.println("Max difference of a single screenshot for " + entry.getKey() + ":\n" + entry.getValue().summary.differenceMax + " (" + Math.round(report.summary.differenceMax * 100.0) + " %)");
                System.out.println("");
            }
            System.out.println("Sum of overall screenshot differences:\n" + report.summary.differenceSum + " (" + Math.round(report.summary.differenceSum * 100.0) + " %)");
            System.out.println("Max difference of a single screenshot:\n" + report.summary.differenceMax + " (" + Math.round(report.summary.differenceMax * 100.0) + " %)");
            if (!Main.useLegacyReportFormat(config)) {
                for (Map.Entry<String, UrlReport> entry : entries) {
                    if (config.urls == null || !(entry.getValue().summary.differenceMax > (double)config.urls.get((Object)entry.getKey()).maxDiff)) continue;
                    System.out.println("JLineup finished. There was a difference between before and after. Return code is 1.");
                    System.exit(1);
                }
            }
        }
        System.out.printf("JLineup run finished for step '%s'%n", new Object[]{parameters.getStep()});
    }

    private static void setLogLevelToDebug() {
        Logger root = (Logger)LoggerFactory.getLogger("ROOT");
        root.setLevel(Level.DEBUG);
    }

    private static boolean useLegacyReportFormat(Config config) {
        boolean bl;
        if (config.reportFormat != null && config.reportFormat == 1) {
            bl = true;
        } else {
            if (config.reportFormat == null) {
                // empty if block
            }
            bl = false;
        }
        return bl;
    }

    private static String getVersion() {
        return String.format("%s [%s]%n", Util.readVersion(), Util.readCommit());
    }

    private static String createPrettyConfigJson(Config config) {
        return new GsonBuilder().setPrettyPrinting().create().toJson(config);
    }
}

