/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser;

import org.attoparser.HtmlElement;
import org.attoparser.IMarkupHandler;
import org.attoparser.ParseException;
import org.attoparser.ParseStatus;

class HtmlAutoOpenElement
extends HtmlElement {
    private final char[][] autoOpenParents;
    private final char[][] autoOpenLimits;

    HtmlAutoOpenElement(String name, String[] autoOpenParents, String[] autoOpenLimits) {
        super(name);
        Object autoOpenLimitsCharArray;
        if (autoOpenParents == null) {
            throw new IllegalArgumentException("The array of auto-open parents cannot be null");
        }
        char[][] autoOpenParentsCharArray = new char[autoOpenParents.length][];
        for (int i = 0; i < autoOpenParentsCharArray.length; ++i) {
            autoOpenParentsCharArray[i] = autoOpenParents[i].toCharArray();
        }
        if (autoOpenLimits != null) {
            autoOpenLimitsCharArray = new char[autoOpenLimits.length][];
            for (int i = 0; i < ((char[][])autoOpenLimitsCharArray).length; ++i) {
                autoOpenLimitsCharArray[i] = autoOpenLimits[i].toCharArray();
            }
        } else {
            autoOpenLimitsCharArray = null;
        }
        this.autoOpenParents = autoOpenParentsCharArray;
        this.autoOpenLimits = autoOpenLimitsCharArray;
    }

    public void handleOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col, IMarkupHandler handler, ParseStatus status, boolean autoOpenEnabled, boolean autoCloseEnabled) throws ParseException {
        if (autoOpenEnabled && !status.isAutoOpenCloseDone()) {
            status.setAutoOpenRequired(this.autoOpenParents, this.autoOpenLimits);
            return;
        }
        handler.handleOpenElementStart(buffer, nameOffset, nameLen, line, col);
    }

    public void handleStandaloneElementStart(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col, IMarkupHandler handler, ParseStatus status, boolean autoOpenEnabled, boolean autoCloseEnabled) throws ParseException {
        if (autoOpenEnabled && !status.isAutoOpenCloseDone()) {
            status.setAutoOpenRequired(this.autoOpenParents, this.autoOpenLimits);
            return;
        }
        handler.handleStandaloneElementStart(buffer, nameOffset, nameLen, minimized, line, col);
    }
}

