/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import java.util.Optional;

public class ImageService {
    public static final int SAME_COLOR = Color.BLACK.getRGB();
    public static final int HIGHLIGHT_COLOR = Color.WHITE.getRGB();
    public static final int DIFFERENT_SIZE_COLOR = Color.GRAY.getRGB();
    public static final int PIXEL_DIFFERENCE_THRESHOLD = 0;

    public ImageComparisonResult compareImages(BufferedImage image1, BufferedImage image2, int viewportHeight) {
        if (image1 == null || image2 == null) {
            throw new NullPointerException("Can't compare null imagebuffers");
        }
        if (ImageService.bufferedImagesEqualQuick(image1, image2)) {
            return new ImageComparisonResult(null, 0.0);
        }
        int width1 = image1.getWidth();
        int height1 = image1.getHeight();
        int width2 = image2.getWidth();
        int height2 = image2.getHeight();
        int maxWidth = Math.max(image1.getWidth(), image2.getWidth());
        int maxHeight = Math.max(image1.getHeight(), image2.getHeight());
        int minWidth = Math.min(image1.getWidth(), image2.getWidth());
        int[] image1Pixels = image1.getRGB(0, 0, width1, height1, null, 0, width1);
        int[] image2Pixels = image2.getRGB(0, 0, width2, height2, null, 0, width2);
        int pixelCount1 = width1 * height1;
        int pixelCount2 = width2 * height2;
        int maxPixelCount = maxWidth * maxHeight;
        int minPixelCount = Math.min(pixelCount1, pixelCount2);
        int diffPixelCounter = 0;
        int[] differenceImagePixels = new int[maxPixelCount];
        int i1 = 0;
        int i2 = 0;
        int iD = 0;
        while (iD < maxPixelCount) {
            if (image1Pixels[i1] != image2Pixels[i2]) {
                if (this.getPixelDifference(image1Pixels[i1], image2Pixels[i2]) > 0) {
                    differenceImagePixels[iD] = HIGHLIGHT_COLOR;
                    ++diffPixelCounter;
                } else {
                    differenceImagePixels[iD] = SAME_COLOR;
                }
            } else {
                differenceImagePixels[iD] = SAME_COLOR;
            }
            ++i2;
            ++iD;
            if (width1 < width2 && ++i1 % minWidth == 0) {
                while (i2 % maxWidth != 0) {
                    ++i2;
                    differenceImagePixels[iD] = DIFFERENT_SIZE_COLOR;
                    ++diffPixelCounter;
                    ++iD;
                }
            } else if (width2 < width1 && i2 % minWidth == 0) {
                while (i1 % maxWidth != 0) {
                    ++i1;
                    differenceImagePixels[iD] = DIFFERENT_SIZE_COLOR;
                    ++diffPixelCounter;
                    ++iD;
                }
            }
            if (i1 != minPixelCount && i2 != minPixelCount) continue;
            while (iD < maxPixelCount) {
                if (iD % maxWidth < minWidth) {
                    differenceImagePixels[iD] = DIFFERENT_SIZE_COLOR;
                    ++diffPixelCounter;
                } else {
                    differenceImagePixels[iD] = SAME_COLOR;
                }
                ++iD;
            }
        }
        double difference = 1.0 * (double)diffPixelCounter / (double)Math.min(maxPixelCount, maxWidth * viewportHeight);
        BufferedImage out = new BufferedImage(maxWidth, maxHeight, 1);
        out.setRGB(0, 0, maxWidth, maxHeight, differenceImagePixels, 0, maxWidth);
        return new ImageComparisonResult(out, difference);
    }

    private int getPixelDifference(int pixelA, int pixelB) {
        int[] argbA = this.getARGB(pixelA);
        int[] argbB = this.getARGB(pixelB);
        int diff = 0;
        for (int i = 0; i < argbA.length; ++i) {
            diff += Math.abs(argbA[i] - argbB[i]);
        }
        return diff;
    }

    private int[] getARGB(int pixel) {
        int rgb = pixel;
        int alpha = rgb >> 24 & 0xFF;
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return new int[]{alpha, red, green, blue};
    }

    public static boolean bufferedImagesEqual(BufferedImage image1, BufferedImage image2) {
        if (image1.getWidth() == image2.getWidth() && image1.getHeight() == image2.getHeight()) {
            for (int xPosition = 0; xPosition < image1.getWidth(); ++xPosition) {
                for (int yPosition = 0; yPosition < image1.getHeight(); ++yPosition) {
                    if (image1.getRGB(xPosition, yPosition) == image2.getRGB(xPosition, yPosition)) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean bufferedImagesEqualQuick(BufferedImage image1, BufferedImage image2) {
        DataBuffer dataBuffer1 = image1.getRaster().getDataBuffer();
        DataBuffer dataBuffer2 = image2.getRaster().getDataBuffer();
        if (dataBuffer1 instanceof DataBufferByte && dataBuffer2 instanceof DataBufferByte) {
            DataBufferByte dataBufferBytes1 = (DataBufferByte)dataBuffer1;
            DataBufferByte dataBufferBytes2 = (DataBufferByte)dataBuffer2;
            for (int bank = 0; bank < dataBufferBytes1.getNumBanks(); ++bank) {
                byte[] bytes2;
                byte[] bytes1 = dataBufferBytes1.getData(bank);
                if (Arrays.equals(bytes1, bytes2 = dataBufferBytes2.getData(bank))) continue;
                return false;
            }
        } else if (dataBuffer1 instanceof DataBufferInt && dataBuffer2 instanceof DataBufferInt) {
            DataBufferInt dataBufferInt1 = (DataBufferInt)dataBuffer1;
            DataBufferInt dataBufferInt2 = (DataBufferInt)dataBuffer2;
            for (int bank = 0; bank < dataBufferInt1.getNumBanks(); ++bank) {
                int[] ints2;
                int[] ints1 = dataBufferInt1.getData(bank);
                if (Arrays.equals(ints1, ints2 = dataBufferInt2.getData(bank))) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static class ImageComparisonResult {
        private final BufferedImage differenceImage;
        private final double difference;

        public ImageComparisonResult(BufferedImage differenceImage, double difference) {
            this.differenceImage = differenceImage;
            this.difference = difference;
        }

        public Optional<BufferedImage> getDifferenceImage() {
            return Optional.ofNullable(this.differenceImage);
        }

        public double getDifference() {
            return this.difference;
        }
    }
}

