/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.browser;

import de.otto.jlineup.browser.BrowserUtils;
import de.otto.jlineup.browser.ScreenshotContext;
import de.otto.jlineup.config.Config;
import de.otto.jlineup.config.Cookie;
import de.otto.jlineup.config.Parameters;
import de.otto.jlineup.file.FileService;
import de.otto.jlineup.image.ImageService;
import java.awt.AWTException;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Browser
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(Browser.class);
    public static final int THREADPOOL_SUBMIT_SHUFFLE_TIME_IN_MS = 233;
    public static final int DEFAULT_SLEEP_AFTER_SCROLL_MILLIS = 50;
    static final String JS_DOCUMENT_HEIGHT_CALL = "return Math.max( document.body.scrollHeight, document.body.offsetHeight, document.documentElement.clientHeight, document.documentElement.scrollHeight, document.documentElement.offsetHeight );";
    static final String JS_CLIENT_VIEWPORT_HEIGHT_CALL = "return document.documentElement.clientHeight";
    static final String JS_SET_LOCAL_STORAGE_CALL = "localStorage.setItem('%s','%s')";
    static final String JS_SCROLL_CALL = "window.scrollBy(0,%d)";
    static final String JS_SCROLL_TO_TOP_CALL = "window.scrollTo(0, 0);";
    private final Parameters parameters;
    private final Config config;
    private final FileService fileService;
    private final BrowserUtils browserUtils;
    private ExecutorService threadPool;
    private ConcurrentHashMap<String, WebDriver> webDrivers = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Set<String>> cacheWarmupMarksMap = new ConcurrentHashMap();

    public Browser(Parameters parameters, Config config, FileService fileService, BrowserUtils browserUtils) {
        this.parameters = parameters;
        this.config = config;
        this.fileService = fileService;
        this.browserUtils = browserUtils;
        this.threadPool = Executors.newFixedThreadPool(config.threads);
    }

    @Override
    public void close() throws Exception {
        this.webDrivers.values().forEach(WebDriver::close);
        this.webDrivers.values().forEach(WebDriver::quit);
        this.webDrivers.clear();
    }

    public void takeScreenshots() throws IOException, InterruptedException {
        boolean before = !this.parameters.isAfter();
        List<ScreenshotContext> screenshotContextList = BrowserUtils.buildScreenshotContextListFromConfigAndState(this.parameters, this.config, before);
        this.takeScreenshots(screenshotContextList);
    }

    void takeScreenshots(List<ScreenshotContext> screenshotContextList) throws IOException, InterruptedException {
        int counter = 0;
        for (ScreenshotContext screenshotContext : screenshotContextList) {
            this.threadPool.submit(() -> {
                try {
                    this.takeScreenshotsForContext(screenshotContext);
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            });
            Thread.sleep(counter += 233);
        }
        this.threadPool.shutdown();
        this.threadPool.awaitTermination(15L, TimeUnit.MINUTES);
    }

    private void takeScreenshotsForContext(ScreenshotContext screenshotContext) throws InterruptedException, IOException {
        WebDriver localDriver = this.getWebDriver();
        this.moveMouseToZeroZero();
        localDriver.manage().window().setPosition(new Point(0, 0));
        localDriver.manage().window().setSize(new Dimension(screenshotContext.windowWidth, this.config.windowHeight));
        String url = BrowserUtils.buildUrl(screenshotContext.url, screenshotContext.path, screenshotContext.urlConfig.envMapping);
        String rootUrl = BrowserUtils.buildUrl(screenshotContext.url, "/", screenshotContext.urlConfig.envMapping);
        if (this.areThereCookiesOrLocalStorage(screenshotContext)) {
            LOG.info(String.format("Getting root url: %s to set cookies and local storage", rootUrl));
            localDriver.get(rootUrl);
            this.setCookies(screenshotContext);
            this.setLocalStorage(screenshotContext);
        }
        LOG.info(String.format("Browsing to %s with window size %dx%d", url, screenshotContext.windowWidth, this.config.windowHeight));
        localDriver.get(url);
        this.checkBrowserCacheWarmup(screenshotContext, url, localDriver);
        Long pageHeight = this.getPageHeight();
        Long viewportHeight = this.getViewportHeight();
        if (screenshotContext.urlConfig.waitAfterPageLoad > 0) {
            try {
                LOG.debug(String.format("Waiting for %d seconds (wait-after-page-load)", screenshotContext.urlConfig.waitAfterPageLoad));
                Thread.sleep(screenshotContext.urlConfig.waitAfterPageLoad * 1000);
            }
            catch (InterruptedException e) {
                LOG.error(e.getMessage(), e);
            }
        }
        if (this.config.globalWaitAfterPageLoad.floatValue() > 0.0f) {
            LOG.debug(String.format("Waiting for %s seconds (global wait-after-page-load)", this.config.globalWaitAfterPageLoad));
            Thread.sleep(Math.round(this.config.globalWaitAfterPageLoad.floatValue() * 1000.0f));
        }
        LOG.debug("Page height before scrolling: {}", (Object)pageHeight);
        LOG.debug("Viewport height of browser window: {}", (Object)viewportHeight);
        this.scrollToTop();
        this.executeJavaScript(screenshotContext.urlConfig.javaScript);
        int yPosition = 0;
        while ((long)yPosition < pageHeight && yPosition <= screenshotContext.urlConfig.maxScrollHeight) {
            BufferedImage currentScreenshot = this.takeScreenshot();
            currentScreenshot = this.waitForNoAnimation(screenshotContext, currentScreenshot);
            this.fileService.writeScreenshot(currentScreenshot, screenshotContext.url, screenshotContext.path, screenshotContext.windowWidth, yPosition, screenshotContext.before ? "before" : "after");
            if (this.config.browser == Type.PHANTOMJS) break;
            LOG.debug("topOfViewport: {}, pageHeight: {}", (Object)yPosition, (Object)pageHeight);
            this.scrollBy(viewportHeight.intValue());
            if (screenshotContext.urlConfig.waitAfterScroll > 0) {
                TimeUnit.SECONDS.sleep(screenshotContext.urlConfig.waitAfterScroll);
            }
            pageHeight = this.getPageHeight();
            yPosition = (int)((long)yPosition + viewportHeight);
        }
    }

    private WebDriver initializeWebDriver() {
        WebDriver driver = this.browserUtils.getWebDriverByConfig(this.config);
        driver.manage().timeouts().implicitlyWait(60L, TimeUnit.SECONDS);
        return driver;
    }

    private Set<String> initializeCacheWarmupMarks() {
        return new HashSet<String>();
    }

    private boolean areThereCookiesOrLocalStorage(ScreenshotContext screenshotContext) {
        return screenshotContext.urlConfig.cookies != null && screenshotContext.urlConfig.cookies.size() > 0 || screenshotContext.urlConfig.localStorage != null && screenshotContext.urlConfig.localStorage.size() > 0;
    }

    private void setCookies(ScreenshotContext screenshotContext) {
        if (this.config.browser == Type.PHANTOMJS) {
            LOG.debug("Setting cookies for PhantomJS");
            this.setCookiesPhantomJS(screenshotContext.urlConfig.cookies);
        } else {
            LOG.debug("Setting cookies");
            this.setCookies(screenshotContext.urlConfig.cookies);
        }
    }

    private void checkBrowserCacheWarmup(ScreenshotContext screenshotContext, String url, WebDriver driver) {
        Set browserCacheWarmupMarks;
        int warmupTime = screenshotContext.urlConfig.warmupBrowserCacheTime;
        if (warmupTime > 0 && !(browserCacheWarmupMarks = this.cacheWarmupMarksMap.computeIfAbsent(Thread.currentThread().getName(), k -> this.initializeCacheWarmupMarks())).contains(url)) {
            LOG.debug(String.format("First call of %s - waiting %d seconds for cache warmup", url, warmupTime));
            browserCacheWarmupMarks.add(url);
            try {
                Thread.sleep(warmupTime * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            LOG.debug("Cache warmup time is over. Getting " + url + " again.");
            driver.get(url);
        }
    }

    private BufferedImage takeScreenshot() throws IOException {
        File screenshot = ((TakesScreenshot)((Object)this.getWebDriver())).getScreenshotAs(OutputType.FILE);
        return ImageIO.read(screenshot);
    }

    private BufferedImage waitForNoAnimation(ScreenshotContext screenshotContext, BufferedImage currentScreenshot) throws IOException {
        float waitForNoAnimation = screenshotContext.urlConfig.waitForNoAnimationAfterScroll;
        if (waitForNoAnimation > 0.0f) {
            long beginTime = System.currentTimeMillis();
            int sameCounter = 0;
            while (sameCounter < 10 && !this.timeIsOver(beginTime, waitForNoAnimation)) {
                File screenshot = ((TakesScreenshot)((Object)this.getWebDriver())).getScreenshotAs(OutputType.FILE);
                BufferedImage newScreenshot = ImageIO.read(screenshot);
                if (ImageService.bufferedImagesEqualQuick(newScreenshot, currentScreenshot)) {
                    ++sameCounter;
                }
                currentScreenshot = newScreenshot;
            }
        }
        return currentScreenshot;
    }

    private boolean timeIsOver(long beginTime, float waitForNoAnimation) {
        boolean over;
        boolean bl = over = beginTime + (long)(waitForNoAnimation * 1000.0f) < System.currentTimeMillis();
        if (over) {
            LOG.debug("Time is over");
        }
        return over;
    }

    private Long getPageHeight() {
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.getWebDriver());
        return (Long)jse.executeScript(JS_DOCUMENT_HEIGHT_CALL, new Object[0]);
    }

    private Long getViewportHeight() {
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.getWebDriver());
        return (Long)jse.executeScript(JS_CLIENT_VIEWPORT_HEIGHT_CALL, new Object[0]);
    }

    void executeJavaScript(String javaScript) throws InterruptedException {
        if (javaScript == null) {
            return;
        }
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.getWebDriver());
        jse.executeScript(javaScript, new Object[0]);
        Thread.sleep(50L);
    }

    void scrollBy(int viewportHeight) throws InterruptedException {
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.getWebDriver());
        jse.executeScript(String.format(JS_SCROLL_CALL, viewportHeight), new Object[0]);
        Thread.sleep(50L);
    }

    void scrollToTop() throws InterruptedException {
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.getWebDriver());
        jse.executeScript(JS_SCROLL_TO_TOP_CALL, new Object[0]);
        Thread.sleep(50L);
    }

    private void setLocalStorage(ScreenshotContext screenshotContext) {
        this.setLocalStorage(screenshotContext.urlConfig.localStorage);
    }

    void setLocalStorage(Map<String, String> localStorage) {
        if (localStorage == null) {
            return;
        }
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.getWebDriver());
        for (Map.Entry<String, String> localStorageEntry : localStorage.entrySet()) {
            String entry = localStorageEntry.getValue().replace("'", "\"");
            String jsCall = String.format(JS_SET_LOCAL_STORAGE_CALL, localStorageEntry.getKey(), entry);
            jse.executeScript(jsCall, new Object[0]);
        }
    }

    void setCookies(List<Cookie> cookies) {
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            Cookie.Builder cookieBuilder = new Cookie.Builder(cookie.name, cookie.value);
            if (cookie.domain != null) {
                cookieBuilder.domain(cookie.domain);
            }
            if (cookie.path != null) {
                cookieBuilder.path(cookie.path);
            }
            if (cookie.expiry != null) {
                cookieBuilder.expiresOn(cookie.expiry);
            }
            cookieBuilder.isSecure(cookie.secure);
            this.getWebDriver().manage().addCookie(cookieBuilder.build());
        }
    }

    void setCookiesPhantomJS(List<Cookie> cookies) {
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            StringBuilder cookieCallBuilder = new StringBuilder(String.format("document.cookie = '%s=%s;", cookie.name, cookie.value));
            if (cookie.path != null) {
                cookieCallBuilder.append("path=");
                cookieCallBuilder.append(cookie.path);
                cookieCallBuilder.append(";");
            }
            if (cookie.domain != null) {
                cookieCallBuilder.append("domain=");
                cookieCallBuilder.append(cookie.domain);
                cookieCallBuilder.append(";");
            }
            if (cookie.secure) {
                cookieCallBuilder.append("secure;");
            }
            if (cookie.expiry != null) {
                cookieCallBuilder.append("expires=");
                SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", Locale.US);
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                String asGmt = df.format(cookie.expiry.getTime()) + " GMT";
                cookieCallBuilder.append(asGmt);
                cookieCallBuilder.append(";");
            }
            cookieCallBuilder.append("'");
            ((JavascriptExecutor)((Object)this.getWebDriver())).executeScript(cookieCallBuilder.toString(), new Object[0]);
        }
    }

    private WebDriver getWebDriver() {
        return this.webDrivers.computeIfAbsent(Thread.currentThread().getName(), k -> this.initializeWebDriver());
    }

    private void moveMouseToZeroZero() {
        Robot robot = null;
        try {
            robot = new Robot();
            robot.mouseMove(0, 0);
        }
        catch (AWTException e) {
            LOG.error("Can't move mouse to 0,0", e);
        }
    }

    public static enum Type {
        FIREFOX,
        CHROME,
        PHANTOMJS;

    }
}

