/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.thymeleaf.engine.ElementDefinition;
import org.thymeleaf.engine.ElementNames;
import org.thymeleaf.engine.HTMLElementDefinition;
import org.thymeleaf.engine.HTMLElementName;
import org.thymeleaf.engine.HTMLElementType;
import org.thymeleaf.engine.TextElementDefinition;
import org.thymeleaf.engine.TextElementName;
import org.thymeleaf.engine.XMLElementDefinition;
import org.thymeleaf.engine.XMLElementName;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.processor.element.IElementProcessor;
import org.thymeleaf.processor.element.MatchingAttributeName;
import org.thymeleaf.processor.element.MatchingElementName;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.TextUtils;

public final class ElementDefinitions {
    public static final Set<String> ALL_STANDARD_HTML_ELEMENT_NAMES;
    private static final HTMLElementDefinitionSpec HTML;
    private static final HTMLElementDefinitionSpec HEAD;
    private static final HTMLElementDefinitionSpec TITLE;
    private static final HTMLElementDefinitionSpec BASE;
    private static final HTMLElementDefinitionSpec LINK;
    private static final HTMLElementDefinitionSpec META;
    private static final HTMLElementDefinitionSpec STYLE;
    private static final HTMLElementDefinitionSpec SCRIPT;
    private static final HTMLElementDefinitionSpec NOSCRIPT;
    private static final HTMLElementDefinitionSpec BODY;
    private static final HTMLElementDefinitionSpec ARTICLE;
    private static final HTMLElementDefinitionSpec SECTION;
    private static final HTMLElementDefinitionSpec NAV;
    private static final HTMLElementDefinitionSpec ASIDE;
    private static final HTMLElementDefinitionSpec H1;
    private static final HTMLElementDefinitionSpec H2;
    private static final HTMLElementDefinitionSpec H3;
    private static final HTMLElementDefinitionSpec H4;
    private static final HTMLElementDefinitionSpec H5;
    private static final HTMLElementDefinitionSpec H6;
    private static final HTMLElementDefinitionSpec HGROUP;
    private static final HTMLElementDefinitionSpec HEADER;
    private static final HTMLElementDefinitionSpec FOOTER;
    private static final HTMLElementDefinitionSpec ADDRESS;
    private static final HTMLElementDefinitionSpec MAIN;
    private static final HTMLElementDefinitionSpec P;
    private static final HTMLElementDefinitionSpec HR;
    private static final HTMLElementDefinitionSpec PRE;
    private static final HTMLElementDefinitionSpec BLOCKQUOTE;
    private static final HTMLElementDefinitionSpec OL;
    private static final HTMLElementDefinitionSpec UL;
    private static final HTMLElementDefinitionSpec LI;
    private static final HTMLElementDefinitionSpec DL;
    private static final HTMLElementDefinitionSpec DT;
    private static final HTMLElementDefinitionSpec DD;
    private static final HTMLElementDefinitionSpec FIGURE;
    private static final HTMLElementDefinitionSpec FIGCAPTION;
    private static final HTMLElementDefinitionSpec DIV;
    private static final HTMLElementDefinitionSpec A;
    private static final HTMLElementDefinitionSpec EM;
    private static final HTMLElementDefinitionSpec STRONG;
    private static final HTMLElementDefinitionSpec SMALL;
    private static final HTMLElementDefinitionSpec S;
    private static final HTMLElementDefinitionSpec CITE;
    private static final HTMLElementDefinitionSpec G;
    private static final HTMLElementDefinitionSpec DFN;
    private static final HTMLElementDefinitionSpec ABBR;
    private static final HTMLElementDefinitionSpec TIME;
    private static final HTMLElementDefinitionSpec CODE;
    private static final HTMLElementDefinitionSpec VAR;
    private static final HTMLElementDefinitionSpec SAMP;
    private static final HTMLElementDefinitionSpec KBD;
    private static final HTMLElementDefinitionSpec SUB;
    private static final HTMLElementDefinitionSpec SUP;
    private static final HTMLElementDefinitionSpec I;
    private static final HTMLElementDefinitionSpec B;
    private static final HTMLElementDefinitionSpec U;
    private static final HTMLElementDefinitionSpec MARK;
    private static final HTMLElementDefinitionSpec RUBY;
    private static final HTMLElementDefinitionSpec RB;
    private static final HTMLElementDefinitionSpec RT;
    private static final HTMLElementDefinitionSpec RTC;
    private static final HTMLElementDefinitionSpec RP;
    private static final HTMLElementDefinitionSpec BDI;
    private static final HTMLElementDefinitionSpec BDO;
    private static final HTMLElementDefinitionSpec SPAN;
    private static final HTMLElementDefinitionSpec BR;
    private static final HTMLElementDefinitionSpec WBR;
    private static final HTMLElementDefinitionSpec INS;
    private static final HTMLElementDefinitionSpec DEL;
    private static final HTMLElementDefinitionSpec IMG;
    private static final HTMLElementDefinitionSpec IFRAME;
    private static final HTMLElementDefinitionSpec EMBED;
    private static final HTMLElementDefinitionSpec OBJECT;
    private static final HTMLElementDefinitionSpec PARAM;
    private static final HTMLElementDefinitionSpec VIDEO;
    private static final HTMLElementDefinitionSpec AUDIO;
    private static final HTMLElementDefinitionSpec SOURCE;
    private static final HTMLElementDefinitionSpec TRACK;
    private static final HTMLElementDefinitionSpec CANVAS;
    private static final HTMLElementDefinitionSpec MAP;
    private static final HTMLElementDefinitionSpec AREA;
    private static final HTMLElementDefinitionSpec TABLE;
    private static final HTMLElementDefinitionSpec CAPTION;
    private static final HTMLElementDefinitionSpec COLGROUP;
    private static final HTMLElementDefinitionSpec COL;
    private static final HTMLElementDefinitionSpec TBODY;
    private static final HTMLElementDefinitionSpec THEAD;
    private static final HTMLElementDefinitionSpec TFOOT;
    private static final HTMLElementDefinitionSpec TR;
    private static final HTMLElementDefinitionSpec TD;
    private static final HTMLElementDefinitionSpec TH;
    private static final HTMLElementDefinitionSpec FORM;
    private static final HTMLElementDefinitionSpec FIELDSET;
    private static final HTMLElementDefinitionSpec LEGEND;
    private static final HTMLElementDefinitionSpec LABEL;
    private static final HTMLElementDefinitionSpec INPUT;
    private static final HTMLElementDefinitionSpec BUTTON;
    private static final HTMLElementDefinitionSpec SELECT;
    private static final HTMLElementDefinitionSpec DATALIST;
    private static final HTMLElementDefinitionSpec OPTGROUP;
    private static final HTMLElementDefinitionSpec OPTION;
    private static final HTMLElementDefinitionSpec TEXTAREA;
    private static final HTMLElementDefinitionSpec KEYGEN;
    private static final HTMLElementDefinitionSpec OUTPUT;
    private static final HTMLElementDefinitionSpec PROGRESS;
    private static final HTMLElementDefinitionSpec METER;
    private static final HTMLElementDefinitionSpec DETAILS;
    private static final HTMLElementDefinitionSpec SUMMARY;
    private static final HTMLElementDefinitionSpec COMMAND;
    private static final HTMLElementDefinitionSpec MENU;
    private static final HTMLElementDefinitionSpec MENUITEM;
    private static final HTMLElementDefinitionSpec DIALOG;
    private static final HTMLElementDefinitionSpec TEMPLATE;
    private static final HTMLElementDefinitionSpec ELEMENT;
    private static final HTMLElementDefinitionSpec DECORATOR;
    private static final HTMLElementDefinitionSpec CONTENT;
    private static final HTMLElementDefinitionSpec SHADOW;
    private final ElementDefinitionRepository htmlElementRepository;
    private final ElementDefinitionRepository xmlElementRepository;
    private final ElementDefinitionRepository textElementRepository;
    private final ElementDefinitionRepository javascriptElementRepository;
    private final ElementDefinitionRepository cssElementRepository;

    public ElementDefinitions(Map<TemplateMode, Set<IElementProcessor>> elementProcessorsByTemplateMode) {
        ArrayList<HTMLElementDefinition> standardHTMLElementDefinitions = new ArrayList<HTMLElementDefinition>(HTMLElementDefinitionSpec.ALL_SPECS.size() + 1);
        for (HTMLElementDefinitionSpec definitionSpec : HTMLElementDefinitionSpec.ALL_SPECS) {
            standardHTMLElementDefinitions.add(ElementDefinitions.buildHTMLElementDefinition(definitionSpec.name, definitionSpec.type, elementProcessorsByTemplateMode.get((Object)TemplateMode.HTML)));
        }
        this.htmlElementRepository = new ElementDefinitionRepository(TemplateMode.HTML, elementProcessorsByTemplateMode);
        this.xmlElementRepository = new ElementDefinitionRepository(TemplateMode.XML, elementProcessorsByTemplateMode);
        this.textElementRepository = new ElementDefinitionRepository(TemplateMode.TEXT, elementProcessorsByTemplateMode);
        this.javascriptElementRepository = new ElementDefinitionRepository(TemplateMode.JAVASCRIPT, elementProcessorsByTemplateMode);
        this.cssElementRepository = new ElementDefinitionRepository(TemplateMode.CSS, elementProcessorsByTemplateMode);
        for (HTMLElementDefinition elementDefinition : standardHTMLElementDefinitions) {
            this.htmlElementRepository.storeStandardElement(elementDefinition);
        }
    }

    private static HTMLElementDefinition buildHTMLElementDefinition(HTMLElementName name, HTMLElementType type, Set<IElementProcessor> elementProcessors) {
        LinkedHashSet<IElementProcessor> associatedProcessors = new LinkedHashSet<IElementProcessor>(2);
        if (elementProcessors != null) {
            for (IElementProcessor processor : elementProcessors) {
                TemplateMode templateMode = processor.getTemplateMode();
                if (templateMode != TemplateMode.HTML) continue;
                MatchingElementName matchingElementName = processor.getMatchingElementName();
                MatchingAttributeName matchingAttributeName = processor.getMatchingAttributeName();
                if (matchingElementName != null && matchingElementName.getTemplateMode() != TemplateMode.HTML || matchingAttributeName != null && matchingAttributeName.getTemplateMode() != TemplateMode.HTML) {
                    throw new ConfigurationException("HTML processors must return HTML element names and HTML attribute names (processor: " + processor.getClass().getName() + ")");
                }
                if (matchingAttributeName != null && !matchingAttributeName.isMatchingAllAttributes() || matchingElementName != null && !matchingElementName.matches(name)) continue;
                associatedProcessors.add(processor);
            }
        }
        return new HTMLElementDefinition(name, type, associatedProcessors);
    }

    private static XMLElementDefinition buildXMLElementDefinition(XMLElementName name, Set<IElementProcessor> elementProcessors) {
        LinkedHashSet<IElementProcessor> associatedProcessors = new LinkedHashSet<IElementProcessor>(2);
        if (elementProcessors != null) {
            for (IElementProcessor processor : elementProcessors) {
                TemplateMode templateMode = processor.getTemplateMode();
                if (templateMode != TemplateMode.XML) continue;
                MatchingElementName matchingElementName = processor.getMatchingElementName();
                MatchingAttributeName matchingAttributeName = processor.getMatchingAttributeName();
                if (matchingElementName != null && matchingElementName.getTemplateMode() != TemplateMode.XML || matchingAttributeName != null && matchingAttributeName.getTemplateMode() != TemplateMode.XML) {
                    throw new ConfigurationException("XML processors must return XML element names and XML attribute names (processor: " + processor.getClass().getName() + ")");
                }
                if (matchingAttributeName != null && !matchingAttributeName.isMatchingAllAttributes() || matchingElementName != null && !matchingElementName.matches(name)) continue;
                associatedProcessors.add(processor);
            }
        }
        return new XMLElementDefinition(name, associatedProcessors);
    }

    private static TextElementDefinition buildTextElementDefinition(TemplateMode templateMode, TextElementName name, Set<IElementProcessor> elementProcessors) {
        LinkedHashSet<IElementProcessor> associatedProcessors = new LinkedHashSet<IElementProcessor>(2);
        if (elementProcessors != null) {
            for (IElementProcessor processor : elementProcessors) {
                if (processor.getTemplateMode() != templateMode) continue;
                MatchingElementName matchingElementName = processor.getMatchingElementName();
                MatchingAttributeName matchingAttributeName = processor.getMatchingAttributeName();
                if (matchingElementName != null && matchingElementName.getTemplateMode() != templateMode || matchingAttributeName != null && matchingAttributeName.getTemplateMode() != templateMode) {
                    throw new ConfigurationException((Object)((Object)templateMode) + " processors must return " + (Object)((Object)templateMode) + "element names and " + (Object)((Object)templateMode) + " attribute names (processor: " + processor.getClass().getName() + ")");
                }
                if (matchingAttributeName != null && !matchingAttributeName.isMatchingAllAttributes() || matchingElementName != null && !matchingElementName.matches(name)) continue;
                associatedProcessors.add(processor);
            }
        }
        return new TextElementDefinition(name, associatedProcessors);
    }

    public ElementDefinition forName(TemplateMode templateMode, String elementName) {
        if (templateMode == null) {
            throw new IllegalArgumentException("Template Mode cannot be null");
        }
        switch (templateMode) {
            case HTML: {
                return this.forHTMLName(elementName);
            }
            case XML: {
                return this.forXMLName(elementName);
            }
            case TEXT: {
                return this.forTextName(elementName);
            }
            case JAVASCRIPT: {
                return this.forJavaScriptName(elementName);
            }
            case CSS: {
                return this.forCSSName(elementName);
            }
            case RAW: {
                throw new IllegalArgumentException("Element Definitions cannot be obtained for " + (Object)((Object)templateMode) + " template mode ");
            }
        }
        throw new IllegalArgumentException("Unknown template mode " + (Object)((Object)templateMode));
    }

    public ElementDefinition forName(TemplateMode templateMode, String prefix, String elementName) {
        if (templateMode == null) {
            throw new IllegalArgumentException("Template Mode cannot be null");
        }
        switch (templateMode) {
            case HTML: {
                return this.forHTMLName(prefix, elementName);
            }
            case XML: {
                return this.forXMLName(prefix, elementName);
            }
            case TEXT: {
                return this.forTextName(prefix, elementName);
            }
            case JAVASCRIPT: {
                return this.forJavaScriptName(prefix, elementName);
            }
            case CSS: {
                return this.forCSSName(prefix, elementName);
            }
            case RAW: {
                throw new IllegalArgumentException("Element Definitions cannot be obtained for " + (Object)((Object)templateMode) + " template mode ");
            }
        }
        throw new IllegalArgumentException("Unknown template mode " + (Object)((Object)templateMode));
    }

    public ElementDefinition forName(TemplateMode templateMode, char[] elementName, int elementNameOffset, int elementNameLen) {
        if (templateMode == null) {
            throw new IllegalArgumentException("Template Mode cannot be null");
        }
        switch (templateMode) {
            case HTML: {
                return this.forHTMLName(elementName, elementNameOffset, elementNameLen);
            }
            case XML: {
                return this.forXMLName(elementName, elementNameOffset, elementNameLen);
            }
            case TEXT: {
                return this.forTextName(elementName, elementNameOffset, elementNameLen);
            }
            case JAVASCRIPT: {
                return this.forJavaScriptName(elementName, elementNameOffset, elementNameLen);
            }
            case CSS: {
                return this.forCSSName(elementName, elementNameOffset, elementNameLen);
            }
            case RAW: {
                throw new IllegalArgumentException("Element Definitions cannot be obtained for " + (Object)((Object)templateMode) + " template mode ");
            }
        }
        throw new IllegalArgumentException("Unknown template mode " + (Object)((Object)templateMode));
    }

    public HTMLElementDefinition forHTMLName(String elementName) {
        if (elementName == null || elementName.length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (HTMLElementDefinition)this.htmlElementRepository.getElement(elementName);
    }

    public HTMLElementDefinition forHTMLName(String prefix, String elementName) {
        if (elementName == null || elementName.length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (HTMLElementDefinition)this.htmlElementRepository.getElement(prefix, elementName);
    }

    public HTMLElementDefinition forHTMLName(char[] elementName, int elementNameOffset, int elementNameLen) {
        if (elementName == null || elementNameLen == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (elementNameOffset < 0 || elementNameLen < 0) {
            throw new IllegalArgumentException("Both name offset and length must be equal to or greater than zero");
        }
        return (HTMLElementDefinition)this.htmlElementRepository.getElement(elementName, elementNameOffset, elementNameLen);
    }

    public XMLElementDefinition forXMLName(String elementName) {
        if (elementName == null || elementName.length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (XMLElementDefinition)this.xmlElementRepository.getElement(elementName);
    }

    public XMLElementDefinition forXMLName(String prefix, String elementName) {
        if (elementName == null || elementName.length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (XMLElementDefinition)this.xmlElementRepository.getElement(prefix, elementName);
    }

    public XMLElementDefinition forXMLName(char[] elementName, int elementNameOffset, int elementNameLen) {
        if (elementName == null || elementNameLen == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (elementNameOffset < 0 || elementNameLen < 0) {
            throw new IllegalArgumentException("Both name offset and length must be equal to or greater than zero");
        }
        return (XMLElementDefinition)this.xmlElementRepository.getElement(elementName, elementNameOffset, elementNameLen);
    }

    public TextElementDefinition forTextName(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        return (TextElementDefinition)this.textElementRepository.getElement(elementName);
    }

    public TextElementDefinition forTextName(String prefix, String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        return (TextElementDefinition)this.textElementRepository.getElement(prefix, elementName);
    }

    public TextElementDefinition forTextName(char[] elementName, int elementNameOffset, int elementNameLen) {
        if (elementName == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (elementNameOffset < 0 || elementNameLen < 0) {
            throw new IllegalArgumentException("Both name offset and length must be equal to or greater than zero");
        }
        return (TextElementDefinition)this.textElementRepository.getElement(elementName, elementNameOffset, elementNameLen);
    }

    public TextElementDefinition forJavaScriptName(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (TextElementDefinition)this.javascriptElementRepository.getElement(elementName);
    }

    public TextElementDefinition forJavaScriptName(String prefix, String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (TextElementDefinition)this.javascriptElementRepository.getElement(prefix, elementName);
    }

    public TextElementDefinition forJavaScriptName(char[] elementName, int elementNameOffset, int elementNameLen) {
        if (elementName == null) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (elementNameOffset < 0 || elementNameLen < 0) {
            throw new IllegalArgumentException("Both name offset and length must be equal to or greater than zero");
        }
        return (TextElementDefinition)this.javascriptElementRepository.getElement(elementName, elementNameOffset, elementNameLen);
    }

    public TextElementDefinition forCSSName(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (TextElementDefinition)this.cssElementRepository.getElement(elementName);
    }

    public TextElementDefinition forCSSName(String prefix, String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (TextElementDefinition)this.cssElementRepository.getElement(prefix, elementName);
    }

    public TextElementDefinition forCSSName(char[] elementName, int elementNameOffset, int elementNameLen) {
        if (elementName == null) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (elementNameOffset < 0 || elementNameLen < 0) {
            throw new IllegalArgumentException("Both name offset and length must be equal to or greater than zero");
        }
        return (TextElementDefinition)this.cssElementRepository.getElement(elementName, elementNameOffset, elementNameLen);
    }

    static {
        HTML = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("html"), HTMLElementType.NORMAL);
        HEAD = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("head"), HTMLElementType.NORMAL);
        TITLE = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("title"), HTMLElementType.ESCAPABLE_RAW_TEXT);
        BASE = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("base"), HTMLElementType.VOID);
        LINK = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("link"), HTMLElementType.VOID);
        META = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("meta"), HTMLElementType.VOID);
        STYLE = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("style"), HTMLElementType.RAW_TEXT);
        SCRIPT = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("script"), HTMLElementType.RAW_TEXT);
        NOSCRIPT = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("noscript"), HTMLElementType.NORMAL);
        BODY = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("body"), HTMLElementType.NORMAL);
        ARTICLE = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("article"), HTMLElementType.NORMAL);
        SECTION = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("section"), HTMLElementType.NORMAL);
        NAV = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("nav"), HTMLElementType.NORMAL);
        ASIDE = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("aside"), HTMLElementType.NORMAL);
        H1 = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("h1"), HTMLElementType.NORMAL);
        H2 = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("h2"), HTMLElementType.NORMAL);
        H3 = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("h3"), HTMLElementType.NORMAL);
        H4 = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("h4"), HTMLElementType.NORMAL);
        H5 = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("h5"), HTMLElementType.NORMAL);
        H6 = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("h6"), HTMLElementType.NORMAL);
        HGROUP = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("hgroup"), HTMLElementType.NORMAL);
        HEADER = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("header"), HTMLElementType.NORMAL);
        FOOTER = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("footer"), HTMLElementType.NORMAL);
        ADDRESS = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("address"), HTMLElementType.NORMAL);
        MAIN = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("main"), HTMLElementType.NORMAL);
        P = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("p"), HTMLElementType.NORMAL);
        HR = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("hr"), HTMLElementType.VOID);
        PRE = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("pre"), HTMLElementType.NORMAL);
        BLOCKQUOTE = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("blockquote"), HTMLElementType.NORMAL);
        OL = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("ol"), HTMLElementType.NORMAL);
        UL = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("ul"), HTMLElementType.NORMAL);
        LI = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("li"), HTMLElementType.NORMAL);
        DL = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("dl"), HTMLElementType.NORMAL);
        DT = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("dt"), HTMLElementType.NORMAL);
        DD = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("dd"), HTMLElementType.NORMAL);
        FIGURE = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("figure"), HTMLElementType.NORMAL);
        FIGCAPTION = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("figcaption"), HTMLElementType.NORMAL);
        DIV = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("div"), HTMLElementType.NORMAL);
        A = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("a"), HTMLElementType.NORMAL);
        EM = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("em"), HTMLElementType.NORMAL);
        STRONG = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("strong"), HTMLElementType.NORMAL);
        SMALL = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("small"), HTMLElementType.NORMAL);
        S = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("s"), HTMLElementType.NORMAL);
        CITE = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("cite"), HTMLElementType.NORMAL);
        G = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("g"), HTMLElementType.NORMAL);
        DFN = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("dfn"), HTMLElementType.NORMAL);
        ABBR = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("abbr"), HTMLElementType.NORMAL);
        TIME = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("time"), HTMLElementType.NORMAL);
        CODE = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("code"), HTMLElementType.NORMAL);
        VAR = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("var"), HTMLElementType.NORMAL);
        SAMP = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("samp"), HTMLElementType.NORMAL);
        KBD = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("kbd"), HTMLElementType.NORMAL);
        SUB = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("sub"), HTMLElementType.NORMAL);
        SUP = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("sup"), HTMLElementType.NORMAL);
        I = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("i"), HTMLElementType.NORMAL);
        B = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("b"), HTMLElementType.NORMAL);
        U = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("u"), HTMLElementType.NORMAL);
        MARK = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("mark"), HTMLElementType.NORMAL);
        RUBY = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("ruby"), HTMLElementType.NORMAL);
        RB = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("rb"), HTMLElementType.NORMAL);
        RT = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("rt"), HTMLElementType.NORMAL);
        RTC = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("rtc"), HTMLElementType.NORMAL);
        RP = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("rp"), HTMLElementType.NORMAL);
        BDI = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("bdi"), HTMLElementType.NORMAL);
        BDO = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("bdo"), HTMLElementType.NORMAL);
        SPAN = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("span"), HTMLElementType.NORMAL);
        BR = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("br"), HTMLElementType.VOID);
        WBR = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("wbr"), HTMLElementType.VOID);
        INS = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("ins"), HTMLElementType.NORMAL);
        DEL = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("del"), HTMLElementType.NORMAL);
        IMG = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("img"), HTMLElementType.VOID);
        IFRAME = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("iframe"), HTMLElementType.NORMAL);
        EMBED = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("embed"), HTMLElementType.VOID);
        OBJECT = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("object"), HTMLElementType.NORMAL);
        PARAM = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("param"), HTMLElementType.VOID);
        VIDEO = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("video"), HTMLElementType.NORMAL);
        AUDIO = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("audio"), HTMLElementType.NORMAL);
        SOURCE = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("source"), HTMLElementType.VOID);
        TRACK = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("track"), HTMLElementType.VOID);
        CANVAS = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("canvas"), HTMLElementType.NORMAL);
        MAP = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("map"), HTMLElementType.NORMAL);
        AREA = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("area"), HTMLElementType.VOID);
        TABLE = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("table"), HTMLElementType.NORMAL);
        CAPTION = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("caption"), HTMLElementType.NORMAL);
        COLGROUP = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("colgroup"), HTMLElementType.NORMAL);
        COL = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("col"), HTMLElementType.VOID);
        TBODY = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("tbody"), HTMLElementType.NORMAL);
        THEAD = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("thead"), HTMLElementType.NORMAL);
        TFOOT = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("tfoot"), HTMLElementType.NORMAL);
        TR = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("tr"), HTMLElementType.NORMAL);
        TD = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("td"), HTMLElementType.NORMAL);
        TH = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("th"), HTMLElementType.NORMAL);
        FORM = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("form"), HTMLElementType.NORMAL);
        FIELDSET = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("fieldset"), HTMLElementType.NORMAL);
        LEGEND = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("legend"), HTMLElementType.NORMAL);
        LABEL = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("label"), HTMLElementType.NORMAL);
        INPUT = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("input"), HTMLElementType.VOID);
        BUTTON = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("button"), HTMLElementType.NORMAL);
        SELECT = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("select"), HTMLElementType.NORMAL);
        DATALIST = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("datalist"), HTMLElementType.NORMAL);
        OPTGROUP = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("optgroup"), HTMLElementType.NORMAL);
        OPTION = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("option"), HTMLElementType.NORMAL);
        TEXTAREA = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("textarea"), HTMLElementType.ESCAPABLE_RAW_TEXT);
        KEYGEN = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("keygen"), HTMLElementType.VOID);
        OUTPUT = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("output"), HTMLElementType.NORMAL);
        PROGRESS = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("progress"), HTMLElementType.NORMAL);
        METER = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("meter"), HTMLElementType.NORMAL);
        DETAILS = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("details"), HTMLElementType.NORMAL);
        SUMMARY = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("summary"), HTMLElementType.NORMAL);
        COMMAND = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("command"), HTMLElementType.NORMAL);
        MENU = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("menu"), HTMLElementType.NORMAL);
        MENUITEM = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("menuitem"), HTMLElementType.VOID);
        DIALOG = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("dialog"), HTMLElementType.NORMAL);
        TEMPLATE = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("template"), HTMLElementType.RAW_TEXT);
        ELEMENT = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("element"), HTMLElementType.NORMAL);
        DECORATOR = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("decorator"), HTMLElementType.NORMAL);
        CONTENT = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("content"), HTMLElementType.NORMAL);
        SHADOW = new HTMLElementDefinitionSpec(ElementNames.forHTMLName("shadow"), HTMLElementType.NORMAL);
        ArrayList<String> htmlElementDefinitionNamesAux = new ArrayList<String>(HTMLElementDefinitionSpec.ALL_SPECS.size() + 1);
        for (HTMLElementDefinitionSpec elementDefinitionSpec : HTMLElementDefinitionSpec.ALL_SPECS) {
            for (String completeElementName : elementDefinitionSpec.name.completeElementNames) {
                htmlElementDefinitionNamesAux.add(completeElementName);
            }
        }
        Collections.sort(htmlElementDefinitionNamesAux);
        ALL_STANDARD_HTML_ELEMENT_NAMES = Collections.unmodifiableSet(new LinkedHashSet(htmlElementDefinitionNamesAux));
    }

    private static final class HTMLElementDefinitionSpec {
        static final List<HTMLElementDefinitionSpec> ALL_SPECS = new ArrayList<HTMLElementDefinitionSpec>();
        HTMLElementName name;
        HTMLElementType type;

        HTMLElementDefinitionSpec(HTMLElementName name, HTMLElementType type) {
            this.name = name;
            this.type = type;
            ALL_SPECS.add(this);
        }
    }

    static final class ElementDefinitionRepository {
        private final TemplateMode templateMode;
        private final Map<TemplateMode, Set<IElementProcessor>> elementProcessorsByTemplateMode;
        private final List<String> standardRepositoryNames;
        private final List<ElementDefinition> standardRepository;
        private final List<String> repositoryNames;
        private final List<ElementDefinition> repository;
        private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
        private final Lock readLock = this.lock.readLock();
        private final Lock writeLock = this.lock.writeLock();

        ElementDefinitionRepository(TemplateMode templateMode, Map<TemplateMode, Set<IElementProcessor>> elementProcessorsByTemplateMode) {
            this.templateMode = templateMode;
            this.elementProcessorsByTemplateMode = elementProcessorsByTemplateMode;
            this.standardRepositoryNames = templateMode == TemplateMode.HTML ? new ArrayList(150) : null;
            this.standardRepository = templateMode == TemplateMode.HTML ? new ArrayList(150) : null;
            this.repositoryNames = new ArrayList<String>(150);
            this.repository = new ArrayList<ElementDefinition>(150);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ElementDefinition getElement(char[] text, int offset, int len) {
            int index;
            if (this.standardRepository != null && (index = ElementDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.standardRepositoryNames, text, offset, len)) >= 0) {
                return this.standardRepository.get(index);
            }
            this.readLock.lock();
            try {
                index = ElementDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, text, offset, len);
                if (index >= 0) {
                    ElementDefinition elementDefinition = this.repository.get(index);
                    return elementDefinition;
                }
            }
            finally {
                this.readLock.unlock();
            }
            this.writeLock.lock();
            try {
                ElementDefinition elementDefinition = this.storeElement(text, offset, len);
                return elementDefinition;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ElementDefinition getElement(String completeElementName) {
            int index;
            if (this.standardRepository != null && (index = ElementDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.standardRepositoryNames, completeElementName)) >= 0) {
                return this.standardRepository.get(index);
            }
            this.readLock.lock();
            try {
                index = ElementDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, completeElementName);
                if (index >= 0) {
                    ElementDefinition elementDefinition = this.repository.get(index);
                    return elementDefinition;
                }
            }
            finally {
                this.readLock.unlock();
            }
            this.writeLock.lock();
            try {
                ElementDefinition elementDefinition = this.storeElement(completeElementName);
                return elementDefinition;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ElementDefinition getElement(String prefix, String elementName) {
            int index;
            if (this.standardRepository != null && (index = ElementDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.standardRepositoryNames, prefix, elementName)) >= 0) {
                return this.standardRepository.get(index);
            }
            this.readLock.lock();
            try {
                index = ElementDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, prefix, elementName);
                if (index >= 0) {
                    ElementDefinition elementDefinition = this.repository.get(index);
                    return elementDefinition;
                }
            }
            finally {
                this.readLock.unlock();
            }
            this.writeLock.lock();
            try {
                ElementDefinition elementDefinition = this.storeElement(prefix, elementName);
                return elementDefinition;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        private ElementDefinition storeElement(char[] text, int offset, int len) {
            String[] completeElementNames;
            int index = ElementDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, text, offset, len);
            if (index >= 0) {
                return this.repository.get(index);
            }
            Set<IElementProcessor> elementProcessors = this.elementProcessorsByTemplateMode.get((Object)this.templateMode);
            ElementDefinition elementDefinition = this.templateMode == TemplateMode.HTML ? ElementDefinitions.buildHTMLElementDefinition(ElementNames.forHTMLName(text, offset, len), HTMLElementType.NORMAL, elementProcessors) : (this.templateMode == TemplateMode.XML ? ElementDefinitions.buildXMLElementDefinition(ElementNames.forXMLName(text, offset, len), elementProcessors) : ElementDefinitions.buildTextElementDefinition(this.templateMode, ElementNames.forTextName(text, offset, len), elementProcessors));
            for (String completeElementName : completeElementNames = elementDefinition.elementName.completeElementNames) {
                index = ElementDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, completeElementName);
                this.repositoryNames.add((index + 1) * -1, completeElementName);
                this.repository.add((index + 1) * -1, elementDefinition);
            }
            return elementDefinition;
        }

        private ElementDefinition storeElement(String text) {
            String[] completeElementNames;
            int index = ElementDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, text);
            if (index >= 0) {
                return this.repository.get(index);
            }
            Set<IElementProcessor> elementProcessors = this.elementProcessorsByTemplateMode.get((Object)this.templateMode);
            ElementDefinition elementDefinition = this.templateMode == TemplateMode.HTML ? ElementDefinitions.buildHTMLElementDefinition(ElementNames.forHTMLName(text), HTMLElementType.NORMAL, elementProcessors) : (this.templateMode == TemplateMode.XML ? ElementDefinitions.buildXMLElementDefinition(ElementNames.forXMLName(text), elementProcessors) : ElementDefinitions.buildTextElementDefinition(this.templateMode, ElementNames.forTextName(text), elementProcessors));
            for (String completeElementName : completeElementNames = elementDefinition.elementName.completeElementNames) {
                index = ElementDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, completeElementName);
                this.repositoryNames.add((index + 1) * -1, completeElementName);
                this.repository.add((index + 1) * -1, elementDefinition);
            }
            return elementDefinition;
        }

        private ElementDefinition storeElement(String prefix, String elementName) {
            String[] completeElementNames;
            int index = ElementDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, prefix, elementName);
            if (index >= 0) {
                return this.repository.get(index);
            }
            Set<IElementProcessor> elementProcessors = this.elementProcessorsByTemplateMode.get((Object)this.templateMode);
            ElementDefinition elementDefinition = this.templateMode == TemplateMode.HTML ? ElementDefinitions.buildHTMLElementDefinition(ElementNames.forHTMLName(prefix, elementName), HTMLElementType.NORMAL, elementProcessors) : (this.templateMode == TemplateMode.XML ? ElementDefinitions.buildXMLElementDefinition(ElementNames.forXMLName(prefix, elementName), elementProcessors) : ElementDefinitions.buildTextElementDefinition(this.templateMode, ElementNames.forTextName(prefix, elementName), elementProcessors));
            for (String completeElementName : completeElementNames = elementDefinition.elementName.completeElementNames) {
                index = ElementDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, completeElementName);
                this.repositoryNames.add((index + 1) * -1, completeElementName);
                this.repository.add((index + 1) * -1, elementDefinition);
            }
            return elementDefinition;
        }

        private ElementDefinition storeStandardElement(ElementDefinition elementDefinition) {
            String[] completeElementNames;
            for (String completeElementName : completeElementNames = elementDefinition.elementName.completeElementNames) {
                int index = ElementDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.standardRepositoryNames, completeElementName);
                this.standardRepositoryNames.add((index + 1) * -1, completeElementName);
                this.standardRepository.add((index + 1) * -1, elementDefinition);
                index = ElementDefinitionRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, completeElementName);
                this.repositoryNames.add((index + 1) * -1, completeElementName);
                this.repository.add((index + 1) * -1, elementDefinition);
            }
            return elementDefinition;
        }

        private static int binarySearch(boolean caseSensitive, List<String> values, char[] text, int offset, int len) {
            int low = 0;
            int high = values.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                String midVal = values.get(mid);
                int cmp = TextUtils.compareTo(caseSensitive, (CharSequence)midVal, 0, midVal.length(), text, offset, len);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        private static int binarySearch(boolean caseSensitive, List<String> values, String text) {
            int low = 0;
            int high = values.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                String midVal = values.get(mid);
                int cmp = TextUtils.compareTo(caseSensitive, (CharSequence)midVal, text);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        private static int binarySearch(boolean caseSensitive, List<String> values, String prefix, String elementName) {
            if (prefix == null || prefix.trim().length() == 0) {
                return ElementDefinitionRepository.binarySearch(caseSensitive, values, elementName);
            }
            int prefixLen = prefix.length();
            int elementNameLen = elementName.length();
            int low = 0;
            int high = values.size() - 1;
            while (low <= high) {
                int cmp;
                int mid = low + high >>> 1;
                String midVal = values.get(mid);
                int midValLen = midVal.length();
                if (TextUtils.startsWith(caseSensitive, (CharSequence)midVal, prefix)) {
                    if (midValLen <= prefixLen) {
                        low = mid + 1;
                        continue;
                    }
                    cmp = midVal.charAt(prefixLen) - 58;
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    cmp = TextUtils.compareTo(caseSensitive, (CharSequence)midVal, prefixLen + 1, midValLen - (prefixLen + 1), elementName, 0, elementNameLen);
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    return mid;
                }
                cmp = TextUtils.compareTo(caseSensitive, (CharSequence)midVal, prefix);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                throw new IllegalStateException("Bad comparison of midVal \"" + midVal + "\" and prefix \"" + prefix + "\"");
            }
            return -(low + 1);
        }
    }
}

