/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.report;

import com.google.common.annotations.VisibleForTesting;
import de.otto.jlineup.browser.BrowserUtils;
import de.otto.jlineup.config.Config;
import de.otto.jlineup.config.Parameters;
import de.otto.jlineup.config.UrlConfig;
import de.otto.jlineup.file.FileService;
import de.otto.jlineup.image.ImageService;
import de.otto.jlineup.report.ScreenshotComparisonResult;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.IIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotsComparator {
    private static final Logger LOG = LoggerFactory.getLogger(ScreenshotsComparator.class);
    private static final String BEFORE_MATCHER = "_before.png";
    private static final String AFTER_MATCHER = "_after.png";
    private final Parameters parameters;
    private final Config config;
    private final FileService fileService;
    private final ImageService imageService;
    private static final Pattern FIND_VERTICAL_SCROLL_POSITION_PATTERN = Pattern.compile("_([0-9]*?)_\\D*$");
    private static final Pattern FIND_WINDOW_WIDTH_PATTERN = Pattern.compile("([0-9]*?)_[0-9]*?_\\D*$");

    public ScreenshotsComparator(Parameters parameters, Config config, FileService fileService, ImageService imageService) {
        this.parameters = parameters;
        this.config = config;
        this.fileService = fileService;
        this.imageService = imageService;
    }

    public List<ScreenshotComparisonResult> compare() throws IOException {
        LOG.debug("Comparing images...");
        ArrayList<ScreenshotComparisonResult> screenshotComparisonResults = new ArrayList<ScreenshotComparisonResult>();
        for (Map.Entry<String, UrlConfig> urlConfigEntry : this.config.urls.entrySet()) {
            String url = BrowserUtils.prepareDomain(this.parameters, urlConfigEntry.getKey());
            UrlConfig urlConfig = urlConfigEntry.getValue();
            LOG.debug("Url: {}", (Object)url);
            for (String path : urlConfig.paths) {
                LOG.debug("Path: {}", (Object)path);
                String fullUrlWithPath = BrowserUtils.buildUrl(url, path, urlConfig.envMapping);
                List<String> beforeFileNamesList = this.fileService.getFilenamesForStep(path, url, "before");
                ArrayList afterFileNamesList = new ArrayList();
                beforeFileNamesList.forEach(filename -> afterFileNamesList.add(ScreenshotsComparator.switchAfterWithBeforeInFileName(filename)));
                HashSet<String> beforeFileNamesSet = new HashSet<String>(beforeFileNamesList);
                HashSet<String> afterFileNamesSet = new HashSet<String>(this.fileService.getFilenamesForStep(path, url, "after"));
                ArrayList<String> afterFileNamesWithNoBeforeFile = new ArrayList<String>();
                afterFileNamesSet.stream().filter(name -> !beforeFileNamesSet.contains(ScreenshotsComparator.switchAfterWithBeforeInFileName(name))).forEach(afterFileNamesWithNoBeforeFile::add);
                for (int i = 0; i < beforeFileNamesList.size(); ++i) {
                    BufferedImage imageAfter;
                    BufferedImage imageBefore;
                    String beforeFileName = beforeFileNamesList.get(i);
                    String afterFileName = (String)afterFileNamesList.get(i);
                    LOG.debug("Comparing '{}' with '{}'", (Object)beforeFileName, (Object)afterFileName);
                    int yPosition = ScreenshotsComparator.extractVerticalScrollPositionFromFileName(beforeFileName);
                    int windowWidth = ScreenshotsComparator.extractWindowWidthFromFileName(beforeFileName);
                    try {
                        imageBefore = this.fileService.readScreenshot(beforeFileName);
                    }
                    catch (IIOException e) {
                        System.err.println("Can't read screenshot of 'before' step. Did you run JLineup with '--step before' parameter before trying to run '--step after' or --compare?");
                        throw e;
                    }
                    try {
                        imageAfter = this.fileService.readScreenshot(afterFileName);
                    }
                    catch (IIOException e) {
                        screenshotComparisonResults.add(ScreenshotComparisonResult.noAfterImageComparisonResult(fullUrlWithPath, windowWidth, yPosition, beforeFileName));
                        continue;
                    }
                    ImageService.ImageComparisonResult imageComparisonResult = this.imageService.compareImages(imageBefore, imageAfter, this.config.windowHeight);
                    String differenceImagePath = null;
                    if (imageComparisonResult.getDifference() > 0.0 && imageComparisonResult.getDifferenceImage().isPresent()) {
                        differenceImagePath = this.fileService.writeScreenshot(imageComparisonResult.getDifferenceImage().orElse(null), url, path, windowWidth, yPosition, "DIFFERENCE");
                    }
                    screenshotComparisonResults.add(new ScreenshotComparisonResult(fullUrlWithPath, windowWidth, yPosition, imageComparisonResult.getDifference(), beforeFileName, afterFileName, differenceImagePath));
                }
                this.addMissingBeforeFilesToResults(screenshotComparisonResults, fullUrlWithPath, afterFileNamesWithNoBeforeFile);
            }
        }
        screenshotComparisonResults.sort(Comparator.comparing(r -> r.url).thenComparing(r -> r.width).thenComparing(r -> r.verticalScrollPosition));
        return screenshotComparisonResults;
    }

    private void addMissingBeforeFilesToResults(List<ScreenshotComparisonResult> screenshotComparisonResults, String fullUrlWithPath, List<String> afterFileNamesWithNoBeforeFile) {
        screenshotComparisonResults.addAll(afterFileNamesWithNoBeforeFile.stream().map(remainingFile -> ScreenshotComparisonResult.noBeforeImageComparisonResult(fullUrlWithPath, ScreenshotsComparator.extractWindowWidthFromFileName(remainingFile), ScreenshotsComparator.extractVerticalScrollPositionFromFileName(remainingFile), remainingFile)).collect(Collectors.toList()));
    }

    @VisibleForTesting
    static String switchAfterWithBeforeInFileName(String filename) {
        if (filename.contains(BEFORE_MATCHER)) {
            return filename.replace(BEFORE_MATCHER, AFTER_MATCHER);
        }
        if (filename.contains(AFTER_MATCHER)) {
            return filename.replace(AFTER_MATCHER, BEFORE_MATCHER);
        }
        return filename;
    }

    @VisibleForTesting
    static int extractVerticalScrollPositionFromFileName(String fileName) {
        Matcher matcher = FIND_VERTICAL_SCROLL_POSITION_PATTERN.matcher(fileName);
        if (matcher.find()) {
            String group = matcher.group(1);
            return Integer.parseInt(group);
        }
        return 0;
    }

    @VisibleForTesting
    static int extractWindowWidthFromFileName(String fileName) {
        Matcher matcher = FIND_WINDOW_WIDTH_PATTERN.matcher(fileName);
        if (matcher.find()) {
            String group = matcher.group(1);
            return Integer.parseInt(group);
        }
        return 0;
    }
}

