/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.file;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import de.otto.jlineup.config.Parameters;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.imageio.ImageIO;

public class FileService {
    public static final String BEFORE = "before";
    public static final String AFTER = "after";
    public static final String DIVIDER = "_";
    public static final String PNG_EXTENSION = ".png";
    private final Parameters parameters;

    public FileService(Parameters parameters) {
        this.parameters = parameters;
    }

    @VisibleForTesting
    Path createDirIfNotExists(String dirPath) throws IOException {
        Path path = Paths.get(dirPath, new String[0]);
        Files.createDirectories(path, new FileAttribute[0]);
        return path;
    }

    @VisibleForTesting
    void clearDirectory(String path) throws IOException {
        Path directory = Paths.get(path, new String[0]);
        Files.newDirectoryStream(directory).forEach(file -> {
            try {
                Files.delete(file);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public void createOrClearReportDirectory() {
        this.createOrClearDirectoryBelowWorkingDir(this.parameters.getWorkingDirectory(), this.parameters.getReportDirectory());
    }

    private Path getScreenshotDirectory() {
        return Paths.get(this.parameters.getWorkingDirectory() + "/" + this.parameters.getScreenshotDirectory(), new String[0]);
    }

    private Path getReportDirectory() {
        return Paths.get(this.parameters.getWorkingDirectory() + "/" + this.parameters.getReportDirectory(), new String[0]);
    }

    public void createWorkingDirectoryIfNotExists() {
        try {
            this.createDirIfNotExists(this.parameters.getWorkingDirectory());
        }
        catch (IOException e) {
            System.err.println("Could not create or open working directory.");
            System.exit(1);
        }
    }

    public void createOrClearScreenshotsDirectory() {
        this.createOrClearDirectoryBelowWorkingDir(this.parameters.getWorkingDirectory(), this.parameters.getScreenshotDirectory());
    }

    private void createOrClearDirectoryBelowWorkingDir(String workingDirectory, String subDirectory) {
        try {
            String subDirectoryPath = workingDirectory + "/" + subDirectory;
            this.createDirIfNotExists(subDirectoryPath);
            this.clearDirectory(subDirectoryPath);
        }
        catch (IOException e) {
            System.err.println("Could not create or open " + subDirectory + " directory.");
            System.exit(1);
        }
    }

    @VisibleForTesting
    String generateScreenshotFileName(String url, String path, int width, int yPosition, String type) {
        String fileName = this.generateScreenshotFileNamePrefix(url, path) + String.format("%04d", width) + DIVIDER + String.format("%05d", yPosition) + DIVIDER + type;
        fileName = fileName + PNG_EXTENSION;
        return fileName;
    }

    private String generateScreenshotFileNamePrefix(String url, String path) {
        String hash = Hashing.sha1().hashString(url + path, Charsets.UTF_8).toString().substring(0, 7);
        if (path.equals("/") || path.equals("")) {
            path = "root";
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        String fileNamePrefix = url + DIVIDER + path + DIVIDER;
        fileNamePrefix = fileNamePrefix.replace("://", DIVIDER);
        fileNamePrefix = fileNamePrefix.replaceAll("[^A-Za-z0-9\\-_]", DIVIDER);
        fileNamePrefix = fileNamePrefix + hash + DIVIDER;
        return fileNamePrefix;
    }

    @VisibleForTesting
    String getScreenshotPath(String url, String path, int width, int yPosition, String step) {
        return this.parameters.getWorkingDirectory() + (this.parameters.getWorkingDirectory().endsWith("/") ? "" : "/") + this.parameters.getScreenshotDirectory() + (this.parameters.getScreenshotDirectory().endsWith("/") ? "" : "/") + this.generateScreenshotFileName(url, path, width, yPosition, step);
    }

    private String getScreenshotPath(String fileName) {
        return this.parameters.getWorkingDirectory() + (this.parameters.getWorkingDirectory().endsWith("/") ? "" : "/") + this.parameters.getScreenshotDirectory() + (this.parameters.getScreenshotDirectory().endsWith("/") ? "" : "/") + fileName;
    }

    public BufferedImage readScreenshot(String fileName) throws IOException {
        return ImageIO.read(new File(this.getScreenshotPath(fileName)));
    }

    private void writeScreenshot(String fileName, BufferedImage image) throws IOException {
        ImageIO.write((RenderedImage)image, "png", new File(fileName));
    }

    @VisibleForTesting
    List<String> getFileNamesMatchingPattern(Path directory, String matcherPattern) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(matcherPattern);
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory, pathMatcher::matches);){
            dirStream.forEach(filePath -> files.add(filePath.getFileName().toString()));
        }
        Collections.sort(files, Comparator.naturalOrder());
        return files;
    }

    public String writeScreenshot(BufferedImage image, String url, String urlPath, int windowWidth, int yPosition, String step) throws IOException {
        String screenshotPath = this.getScreenshotPath(url, urlPath, windowWidth, yPosition, step);
        this.writeScreenshot(screenshotPath, image);
        return screenshotPath;
    }

    public List<String> getFilenamesForStep(String path, String url, String step) throws IOException {
        String matcherPattern = "glob:**" + this.generateScreenshotFileNamePrefix(url, path) + "*_*_" + step + PNG_EXTENSION;
        Path screenshotDirectory = this.getScreenshotDirectory();
        return this.getFileNamesMatchingPattern(screenshotDirectory, matcherPattern);
    }

    public void writeJsonReport(String reportJson) throws FileNotFoundException {
        try (PrintStream out = new PrintStream(new FileOutputStream(this.getReportDirectory().toString() + "/report.json"));){
            out.print(reportJson);
        }
    }

    public void writeHtmlReport(String htmlReport) throws FileNotFoundException {
        try (PrintStream out = new PrintStream(new FileOutputStream(this.getScreenshotDirectory().toString() + "/report.html"));){
            out.print(htmlReport);
        }
    }
}

