/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.config;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.Parameter;
import de.otto.jlineup.config.Step;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Parameters {
    @Parameter(names={"-?", "--help"}, help=true, description="Shows this help")
    private boolean help = false;
    @Parameter(names={"-s", "--step"}, description="JLineup step - 'before' just takes screenshots, 'after' takes screenshots and compares them with the 'before'-screenshots in the screenshots directory. 'compare' just compares existing screenshots, it's also included in 'after'.")
    private Step step = Step.before;
    @Parameter(names={"--config", "-c"}, description="Config file")
    private String configFile = "lineup.json";
    @Parameter(names={"--working-dir", "-d"}, description="Path to the working directory")
    private String workingDirectory = ".";
    @Parameter(names={"--screenshot-dir", "-sd"}, description="Screenshots directory name - relative to working directory")
    private String screenshotDirectory = "screenshots";
    @Parameter(names={"--report-dir", "-rd"}, description="HTML report directory name - relative to working directory")
    private String reportDirectory = "report";
    @Parameter(names={"--url", "-u"}, description="If you run JLineup without config file, this is the one url that is tested with the default config.")
    private String url = null;
    @Parameter(names={"--print-config"}, description="Prints a default config file to standard out. Useful as quick start.")
    private boolean printConfig = false;
    @Parameter(names={"--debug"}, description="Sets the log level to DEBUG, produces verbose information about the current task.")
    private boolean debug = false;
    @Parameter(names={"--version", "-v"}, description="Prints version information.")
    private boolean version = false;
    @DynamicParameter(names={"--replace-in-url", "-R"}, description="The given keys are replaced with the corresponding values in all urls that are tested.")
    private Map<String, String> urlReplacements = new HashMap<String, String>();

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getScreenshotDirectory() {
        return this.screenshotDirectory;
    }

    public String getReportDirectory() {
        return this.reportDirectory;
    }

    String getConfigFile() {
        return this.configFile;
    }

    public boolean isAfter() {
        return this.step == Step.after;
    }

    public boolean isBefore() {
        return this.step != Step.after && this.step != Step.compare;
    }

    public boolean isJustCompare() {
        return this.step == Step.compare;
    }

    public boolean isHelp() {
        return this.help;
    }

    public Step getStep() {
        return this.step;
    }

    public Map<String, String> getUrlReplacements() {
        return this.urlReplacements;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isPrintConfig() {
        return this.printConfig;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String toString() {
        return "Parameters{help=" + this.help + ", step=" + (Object)((Object)this.step) + ", configFile='" + this.configFile + '\'' + ", workingDirectory='" + this.workingDirectory + '\'' + ", screenshotDirectory='" + this.screenshotDirectory + '\'' + ", reportDirectory='" + this.reportDirectory + '\'' + ", url='" + this.url + '\'' + ", printConfig=" + this.printConfig + ", debug=" + this.debug + ", version=" + this.version + ", urlReplacements=" + this.urlReplacements + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameters that = (Parameters)o;
        return this.help == that.help && this.printConfig == that.printConfig && this.debug == that.debug && this.version == that.version && this.step == that.step && Objects.equals(this.configFile, that.configFile) && Objects.equals(this.workingDirectory, that.workingDirectory) && Objects.equals(this.screenshotDirectory, that.screenshotDirectory) && Objects.equals(this.reportDirectory, that.reportDirectory) && Objects.equals(this.url, that.url) && Objects.equals(this.urlReplacements, that.urlReplacements);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.help, this.step, this.configFile, this.workingDirectory, this.screenshotDirectory, this.reportDirectory, this.url, this.printConfig, this.debug, this.version, this.urlReplacements});
    }

    public boolean isVersion() {
        return this.version;
    }
}

