/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import de.otto.jlineup.browser.Browser;
import de.otto.jlineup.config.Cookie;
import de.otto.jlineup.config.Parameters;
import de.otto.jlineup.config.UrlConfig;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Config {
    public static final String LINEUP_CONFIG_DEFAULT_PATH = "./lineup.json";
    public static final String EXAMPLE_URL = "https://www.example.com";
    public static final Browser.Type DEFAULT_BROWSER = Browser.Type.PHANTOMJS;
    public static final float DEFAULT_MAX_DIFF = 0.0f;
    public static final int DEFAULT_WINDOW_HEIGHT = 800;
    public static final float DEFAULT_GLOBAL_WAIT_AFTER_PAGE_LOAD = 0.0f;
    public static final List<Integer> DEFAULT_WINDOW_WIDTHS = ImmutableList.of(Integer.valueOf(800));
    public static final List<String> DEFAULT_PATHS = ImmutableList.of("/");
    public static final int DEFAULT_MAX_SCROLL_HEIGHT = 100000;
    public static final int DEFAULT_WAIT_AFTER_PAGE_LOAD = 0;
    public static final int DEFAULT_WAIT_FOR_NO_ANIMATION_AFTER_SCROLL = 0;
    public static final int DEFAULT_WARMUP_BROWSER_CACHE_TIME = 0;
    public static final int DEFAULT_THREADS = 1;
    public final Map<String, UrlConfig> urls;
    public final Browser.Type browser;
    @SerializedName(value="wait-after-page-load", alternate={"async-wait"})
    public final Float globalWaitAfterPageLoad;
    @SerializedName(value="window-height")
    public final Integer windowHeight;
    private static final Gson gson = new Gson();
    public int threads;

    public Config() {
        this.urls = null;
        this.browser = DEFAULT_BROWSER;
        this.globalWaitAfterPageLoad = Float.valueOf(0.0f);
        this.windowHeight = 800;
        this.threads = 1;
    }

    public Config(Map<String, UrlConfig> urls, Browser.Type browser, Float globalWaitAfterPageLoad, Integer windowHeight, Integer threads) {
        this.urls = urls;
        this.browser = browser != null ? browser : DEFAULT_BROWSER;
        this.globalWaitAfterPageLoad = Float.valueOf(globalWaitAfterPageLoad != null ? globalWaitAfterPageLoad.floatValue() : 0.0f);
        this.windowHeight = windowHeight != null ? windowHeight : 800;
        this.threads = threads != null ? threads : 1;
    }

    public static Config defaultConfig() {
        return Config.defaultConfig(EXAMPLE_URL);
    }

    public static Config defaultConfig(String url) {
        return new Config(ImmutableMap.of(url, new UrlConfig()), null, null, null, null);
    }

    public static Config exampleConfig() {
        return new Config(ImmutableMap.of("http://www.example.com", new UrlConfig(ImmutableList.of("/", "someOtherPath"), 0.0f, ImmutableList.of(new Cookie("exampleCookieName", "exampleValue", "http://www.example.com", "/", new Date(1000L), true)), ImmutableMap.of("live", "www"), ImmutableMap.of("exampleLocalStorageKey", "value"), ImmutableList.of(Integer.valueOf(600), Integer.valueOf(800), Integer.valueOf(1000)), 100000, 0, 0.0f, 0, "console.log('This is JavaScript!')")), Browser.Type.PHANTOMJS, Float.valueOf(0.0f), 800, 1);
    }

    public static Config readConfig(Parameters parameters) throws FileNotFoundException {
        return Config.readConfig(parameters.getWorkingDirectory(), parameters.getConfigFile());
    }

    public static Config readConfig(String workingDir, String configFileName) throws FileNotFoundException {
        ArrayList<String> searchPaths = new ArrayList<String>();
        Path configFilePath = Paths.get(workingDir + "/" + configFileName, new String[0]);
        searchPaths.add(configFilePath.toString());
        if (!Files.exists(configFilePath, new LinkOption[0])) {
            configFilePath = Paths.get(configFileName, new String[0]);
            searchPaths.add(configFilePath.toString());
            if (!Files.exists(configFilePath, new LinkOption[0])) {
                configFilePath = Paths.get(LINEUP_CONFIG_DEFAULT_PATH, new String[0]);
                searchPaths.add(configFilePath.toString());
                if (!Files.exists(configFilePath, new LinkOption[0])) {
                    throw new FileNotFoundException("Config file not found. Search locations were: " + Arrays.toString(searchPaths.toArray()));
                }
            }
        }
        BufferedReader br = new BufferedReader(new FileReader(configFilePath.toString()));
        return gson.fromJson((Reader)br, Config.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        return Objects.equals(this.urls, config.urls) && this.browser == config.browser && Objects.equals(this.globalWaitAfterPageLoad, config.globalWaitAfterPageLoad) && Objects.equals(this.windowHeight, config.windowHeight);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.urls, this.browser, this.globalWaitAfterPageLoad, this.windowHeight});
    }

    public String toString() {
        return "Config{urls=" + this.urls + ", browser=" + (Object)((Object)this.browser) + ", globalWaitAfterPageLoad=" + this.globalWaitAfterPageLoad + ", windowHeight=" + this.windowHeight + '}';
    }
}

