/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.IThrottledTemplateProcessor;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.TemplateSpec;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.engine.EngineContextManager;
import org.thymeleaf.engine.ITemplateHandler;
import org.thymeleaf.engine.ProcessorTemplateHandler;
import org.thymeleaf.engine.TemplateFlowController;
import org.thymeleaf.engine.TemplateModel;
import org.thymeleaf.engine.ThrottledTemplateWriter;
import org.thymeleaf.exceptions.TemplateEngineException;
import org.thymeleaf.exceptions.TemplateOutputException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.util.LoggingUtils;

final class ThrottledTemplateProcessor
implements IThrottledTemplateProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TemplateEngine.class);
    private static final Logger timerLogger = LoggerFactory.getLogger(TemplateEngine.TIMER_LOGGER_NAME);
    private static final int NANOS_IN_SECOND = 1000000;
    private static final String OUTPUT_TYPE_CHARS = "chars";
    private static final String OUTPUT_TYPE_BYTES = "bytes";
    private final TemplateSpec templateSpec;
    private final IEngineContext context;
    private final TemplateModel templateModel;
    private final ITemplateHandler templateHandler;
    private final ProcessorTemplateHandler processorTemplateHandler;
    private final TemplateFlowController flowController;
    private final ThrottledTemplateWriter writer;
    private int offset;
    private boolean eventProcessingFinished;
    private boolean allProcessingFinished;

    public ThrottledTemplateProcessor(TemplateSpec templateSpec, IEngineContext context, TemplateModel templateModel, ITemplateHandler templateHandler, ProcessorTemplateHandler processorTemplateHandler, TemplateFlowController flowController, ThrottledTemplateWriter writer) {
        this.templateSpec = templateSpec;
        this.context = context;
        this.templateModel = templateModel;
        this.templateHandler = templateHandler;
        this.processorTemplateHandler = processorTemplateHandler;
        this.flowController = flowController;
        this.writer = writer;
        this.offset = 0;
        this.eventProcessingFinished = false;
        this.allProcessingFinished = false;
    }

    @Override
    public boolean isFinished() {
        return this.allProcessingFinished;
    }

    private boolean computeFinish() throws IOException {
        if (this.allProcessingFinished) {
            return true;
        }
        this.allProcessingFinished = this.eventProcessingFinished && !this.flowController.processorTemplateHandlerPending && !this.writer.isOverflown();
        return this.allProcessingFinished;
    }

    private void reportFinish(String outputType) {
        if (this.allProcessingFinished && logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] FINISHED OUTPUT OF THROTTLED TEMPLATE \"{}\" WITH LOCALE {}. Maximum overflow was {} {} (overflow buffer grown {} times).", TemplateEngine.threadIndex(), this.templateSpec, this.context.getLocale(), this.writer.getMaxOverflowSize(), outputType, this.writer.getOverflowGrowCount());
        }
    }

    @Override
    public void processAll(Writer writer) {
        this.writer.setOutput(writer);
        this.process(Integer.MAX_VALUE, OUTPUT_TYPE_CHARS);
    }

    @Override
    public void processAll(OutputStream outputStream, Charset charset) {
        this.writer.setOutput(outputStream, charset, Integer.MAX_VALUE);
        this.process(Integer.MAX_VALUE, OUTPUT_TYPE_BYTES);
    }

    @Override
    public void process(int maxOutputInChars, Writer writer) {
        this.writer.setOutput(writer);
        this.process(maxOutputInChars, OUTPUT_TYPE_CHARS);
    }

    @Override
    public void process(int maxOutputInBytes, OutputStream outputStream, Charset charset) {
        this.writer.setOutput(outputStream, charset, maxOutputInBytes);
        this.process(maxOutputInBytes, OUTPUT_TYPE_BYTES);
    }

    private void process(int maxOutput, String outputType) {
        try {
            if (this.allProcessingFinished || maxOutput == 0) {
                return;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] STARTING PROCESS(LIMIT:{} {}) OF THROTTLED TEMPLATE \"{}\" WITH LOCALE {}", TemplateEngine.threadIndex(), maxOutput, outputType, this.templateSpec, this.context.getLocale());
            }
            long startNanos = System.nanoTime();
            this.writer.allow(maxOutput);
            if (!this.computeFinish() && !this.writer.isStopped()) {
                if (this.flowController.processorTemplateHandlerPending) {
                    this.processorTemplateHandler.handlePending();
                }
                if (!this.computeFinish() && !this.writer.isStopped()) {
                    this.offset += this.templateModel.process(this.templateHandler, this.offset, this.flowController);
                    if (this.offset == this.templateModel.size()) {
                        EngineContextManager.disposeEngineContext(this.context);
                        this.eventProcessingFinished = true;
                        this.computeFinish();
                    }
                }
            }
            long endNanos = System.nanoTime();
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] FINISHED PROCESS(LIMIT:{} {}, OUTPUT: {} {}) OF THROTTLED TEMPLATE \"{}\" WITH LOCALE {}", TemplateEngine.threadIndex(), maxOutput, outputType, this.writer.getWrittenCount(), outputType, this.templateSpec, this.context.getLocale());
            }
            if (timerLogger.isTraceEnabled()) {
                BigDecimal elapsed = BigDecimal.valueOf(endNanos - startNanos);
                BigDecimal elapsedMs = elapsed.divide(BigDecimal.valueOf(1000000L), RoundingMode.HALF_UP);
                timerLogger.trace("[THYMELEAF][{}][{}][{}][{}][{}] TEMPLATE \"{}\" WITH LOCALE {} PROCESSED (THROTTLED, LIMIT:{} {}, OUTPUT: {} {}) IN {} nanoseconds (approx. {}ms)", TemplateEngine.threadIndex(), LoggingUtils.loggifyTemplateName(this.templateSpec.getTemplate()), this.context.getLocale(), elapsed, elapsedMs, this.templateSpec, this.context.getLocale(), maxOutput, outputType, this.writer.getWrittenCount(), outputType, elapsed, elapsedMs);
            }
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                throw new TemplateOutputException("An error happened while flushing output writer", this.templateSpec.getTemplate(), -1, -1, e);
            }
        }
        catch (TemplateOutputException e) {
            this.eventProcessingFinished = true;
            this.allProcessingFinished = true;
            logger.error(String.format("[THYMELEAF][%s] Exception processing throttled template \"%s\": %s", TemplateEngine.threadIndex(), this.templateSpec, e.getMessage()), e);
            throw e;
        }
        catch (TemplateEngineException e) {
            this.eventProcessingFinished = true;
            this.allProcessingFinished = true;
            logger.error(String.format("[THYMELEAF][%s] Exception processing throttled template \"%s\": %s", TemplateEngine.threadIndex(), this.templateSpec, e.getMessage()), e);
            throw e;
        }
        catch (Exception e) {
            this.eventProcessingFinished = true;
            this.allProcessingFinished = true;
            logger.error(String.format("[THYMELEAF][%s] Exception processing throttled template \"%s\": %s", TemplateEngine.threadIndex(), this.templateSpec, e.getMessage()), e);
            throw new TemplateProcessingException("Exception processing throttled template", this.templateSpec.toString(), e);
        }
        this.reportFinish(outputType);
    }
}

