/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser.minimize;

import org.attoparser.AbstractChainedMarkupHandler;
import org.attoparser.IMarkupHandler;
import org.attoparser.ParseException;
import org.attoparser.config.ParseConfiguration;
import org.attoparser.util.TextUtil;

public final class MinimizeHtmlMarkupHandler
extends AbstractChainedMarkupHandler {
    private static final String[] BLOCK_ELEMENTS = new String[]{"address", "article", "aside", "audio", "base", "blockquote", "body", "canvas", "caption", "col", "colgroup", "dd", "div", "dl", "dt", "fieldset", "figcaption", "figure", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "li", "link", "meta", "noscript", "ol", "option", "output", "p", "pre", "script", "section", "style", "table", "tbody", "td", "tfoot", "th", "thead", "title", "tr", "ul", "video"};
    private static final String[] PREFORMATTED_ELEMENTS = new String[]{"pre", "script", "style", "textarea"};
    private static final String[] BOOLEAN_ATTRIBUTE_NAMES = new String[]{"allowfullscreen", "async", "autofocus", "autoplay", "checked", "compact", "controls", "declare", "default", "defaultchecked", "defaultmuted", "defaultselected", "defer", "disabled", "draggable", "enabled", "formnovalidate", "hidden", "indeterminate", "inert", "ismap", "itemscope", "loop", "multiple", "muted", "nohref", "noresize", "noshade", "novalidate", "nowrap", "open", "pauseonexit", "readonly", "required", "reversed", "scoped", "seamless", "selected", "sortable", "spellcheck", "translate", "truespeed", "typemustmatch", "visible"};
    private static final char[] SIZE_ONE_WHITE_SPACE = new char[]{' '};
    private static final char[] ATTRIBUTE_OPERATOR = new char[]{'='};
    private final MinimizeMode minimizeMode;
    private char[] internalBuffer = new char[30];
    private boolean lastTextEndedInWhiteSpace = false;
    private boolean lastOpenElementWasBlock = false;
    private boolean lastClosedElementWasBlock = false;
    private boolean lastVisibleEventWasElement = false;
    private boolean pendingInterBlockElementWhiteSpace = false;
    private boolean inPreformattedElement = false;
    private int pendingEventLine = 1;
    private int pendingEventCol = 1;

    public MinimizeHtmlMarkupHandler(MinimizeMode minimizeMode, IMarkupHandler next) {
        super(next);
        if (minimizeMode == null) {
            throw new IllegalArgumentException("Minimize mode cannot be null");
        }
        this.minimizeMode = minimizeMode;
    }

    public void setParseConfiguration(ParseConfiguration parseConfiguration) {
        if (!ParseConfiguration.ParsingMode.HTML.equals((Object)parseConfiguration.getMode())) {
            throw new IllegalArgumentException("The " + this.getClass().getName() + " handler can only be used when parsing in HTML " + "mode. Current parsing mode is " + (Object)((Object)parseConfiguration.getMode()));
        }
        super.setParseConfiguration(parseConfiguration);
    }

    public void handleDocumentStart(long startTimeNanos, int line, int col) throws ParseException {
        this.getNext().handleDocumentStart(startTimeNanos, line, col);
    }

    public void handleDocumentEnd(long endTimeNanos, long totalTimeNanos, int line, int col) throws ParseException {
        this.getNext().handleDocumentEnd(endTimeNanos, totalTimeNanos, line, col);
    }

    public void handleText(char[] buffer, int offset, int len, int line, int col) throws ParseException {
        if (len == 0) {
            return;
        }
        this.flushPendingInterBlockElementWhiteSpace(false);
        if (this.inPreformattedElement) {
            this.lastTextEndedInWhiteSpace = false;
            this.lastVisibleEventWasElement = false;
            this.getNext().handleText(buffer, offset, len, line, col);
            return;
        }
        boolean wasWhiteSpace = this.lastTextEndedInWhiteSpace;
        boolean shouldCompress = false;
        boolean isAllWhiteSpace = true;
        int i = offset;
        int n = len;
        while ((!shouldCompress || isAllWhiteSpace) && n-- != 0) {
            if (MinimizeHtmlMarkupHandler.isWhitespace(buffer[i])) {
                if (wasWhiteSpace || buffer[i] != ' ') {
                    shouldCompress = true;
                }
                wasWhiteSpace = true;
            } else {
                wasWhiteSpace = false;
                isAllWhiteSpace = false;
            }
            ++i;
        }
        if (!shouldCompress) {
            this.lastTextEndedInWhiteSpace = MinimizeHtmlMarkupHandler.isWhitespace(buffer[offset + len - 1]);
            if (this.lastVisibleEventWasElement && isAllWhiteSpace) {
                this.pendingInterBlockElementWhiteSpace = true;
                this.pendingEventLine = line;
                this.pendingEventCol = col;
                this.lastVisibleEventWasElement = false;
                return;
            }
            this.lastVisibleEventWasElement = false;
            this.getNext().handleText(buffer, offset, len, line, col);
            return;
        }
        if (this.internalBuffer.length < len) {
            this.internalBuffer = new char[len];
        }
        wasWhiteSpace = this.lastTextEndedInWhiteSpace;
        int internalBufferSize = 0;
        i = offset;
        n = len;
        while (n-- != 0) {
            char c;
            if (MinimizeHtmlMarkupHandler.isWhitespace(c = buffer[i++])) {
                if (wasWhiteSpace) continue;
                wasWhiteSpace = true;
                this.internalBuffer[internalBufferSize++] = 32;
                continue;
            }
            wasWhiteSpace = false;
            this.internalBuffer[internalBufferSize++] = c;
        }
        if (internalBufferSize > 0) {
            this.lastTextEndedInWhiteSpace = wasWhiteSpace;
            if (this.lastVisibleEventWasElement && isAllWhiteSpace) {
                this.pendingInterBlockElementWhiteSpace = true;
                this.pendingEventLine = line;
                this.pendingEventCol = col;
                this.lastVisibleEventWasElement = false;
                return;
            }
            this.lastVisibleEventWasElement = false;
            this.getNext().handleText(this.internalBuffer, 0, internalBufferSize, line, col);
        }
    }

    private void flushPendingInterBlockElementWhiteSpace(boolean ignore) throws ParseException {
        if (this.pendingInterBlockElementWhiteSpace) {
            this.pendingInterBlockElementWhiteSpace = false;
            if (!ignore) {
                this.getNext().handleText(SIZE_ONE_WHITE_SPACE, 0, 1, this.pendingEventLine, this.pendingEventCol);
            }
        }
    }

    public void handleComment(char[] buffer, int contentOffset, int contentLen, int outerOffset, int outerLen, int line, int col) throws ParseException {
        if (!this.minimizeMode.removeComments) {
            this.flushPendingInterBlockElementWhiteSpace(false);
            this.lastVisibleEventWasElement = false;
            this.lastTextEndedInWhiteSpace = false;
            this.getNext().handleComment(buffer, contentOffset, contentLen, outerOffset, outerLen, line, col);
        }
    }

    public void handleCDATASection(char[] buffer, int contentOffset, int contentLen, int outerOffset, int outerLen, int line, int col) throws ParseException {
        this.flushPendingInterBlockElementWhiteSpace(false);
        this.lastVisibleEventWasElement = false;
        this.lastTextEndedInWhiteSpace = false;
        this.getNext().handleCDATASection(buffer, contentOffset, contentLen, outerOffset, outerLen, line, col);
    }

    public void handleStandaloneElementStart(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col) throws ParseException {
        this.lastTextEndedInWhiteSpace = false;
        boolean ignorePendingWhiteSpace = (this.lastClosedElementWasBlock || this.lastOpenElementWasBlock) && MinimizeHtmlMarkupHandler.isBlockElement(buffer, nameOffset, nameLen);
        this.flushPendingInterBlockElementWhiteSpace(ignorePendingWhiteSpace);
        if (this.minimizeMode.unminimizeStandalones) {
            this.getNext().handleStandaloneElementStart(buffer, nameOffset, nameLen, false, line, col);
        } else {
            this.getNext().handleStandaloneElementStart(buffer, nameOffset, nameLen, minimized, line, col);
        }
    }

    public void handleStandaloneElementEnd(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col) throws ParseException {
        this.lastTextEndedInWhiteSpace = false;
        this.lastClosedElementWasBlock = MinimizeHtmlMarkupHandler.isBlockElement(buffer, nameOffset, nameLen);
        this.lastOpenElementWasBlock = false;
        this.lastVisibleEventWasElement = true;
        if (this.minimizeMode.unminimizeStandalones) {
            this.getNext().handleStandaloneElementEnd(buffer, nameOffset, nameLen, false, line, col);
        } else {
            this.getNext().handleStandaloneElementEnd(buffer, nameOffset, nameLen, minimized, line, col);
        }
    }

    public void handleOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.lastTextEndedInWhiteSpace = false;
        boolean ignorePendingWhiteSpace = (this.lastClosedElementWasBlock || this.lastOpenElementWasBlock) && MinimizeHtmlMarkupHandler.isBlockElement(buffer, nameOffset, nameLen);
        this.flushPendingInterBlockElementWhiteSpace(ignorePendingWhiteSpace);
        if (MinimizeHtmlMarkupHandler.isPreformattedElement(buffer, nameOffset, nameLen)) {
            this.inPreformattedElement = true;
        }
        this.getNext().handleOpenElementStart(buffer, nameOffset, nameLen, line, col);
    }

    public void handleOpenElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.lastTextEndedInWhiteSpace = false;
        this.lastOpenElementWasBlock = MinimizeHtmlMarkupHandler.isBlockElement(buffer, nameOffset, nameLen);
        this.lastClosedElementWasBlock = false;
        this.lastVisibleEventWasElement = true;
        this.getNext().handleOpenElementEnd(buffer, nameOffset, nameLen, line, col);
    }

    public void handleAutoOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.lastTextEndedInWhiteSpace = false;
        boolean ignorePendingWhiteSpace = (this.lastClosedElementWasBlock || this.lastOpenElementWasBlock) && MinimizeHtmlMarkupHandler.isBlockElement(buffer, nameOffset, nameLen);
        this.flushPendingInterBlockElementWhiteSpace(ignorePendingWhiteSpace);
        if (MinimizeHtmlMarkupHandler.isPreformattedElement(buffer, nameOffset, nameLen)) {
            this.inPreformattedElement = true;
        }
        this.getNext().handleAutoOpenElementStart(buffer, nameOffset, nameLen, line, col);
    }

    public void handleAutoOpenElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.lastTextEndedInWhiteSpace = false;
        this.lastOpenElementWasBlock = MinimizeHtmlMarkupHandler.isBlockElement(buffer, nameOffset, nameLen);
        this.lastClosedElementWasBlock = false;
        this.lastVisibleEventWasElement = true;
        this.getNext().handleAutoOpenElementEnd(buffer, nameOffset, nameLen, line, col);
    }

    public void handleCloseElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.lastTextEndedInWhiteSpace = false;
        boolean ignorePendingWhiteSpace = this.lastClosedElementWasBlock && MinimizeHtmlMarkupHandler.isBlockElement(buffer, nameOffset, nameLen);
        this.flushPendingInterBlockElementWhiteSpace(ignorePendingWhiteSpace);
        if (MinimizeHtmlMarkupHandler.isPreformattedElement(buffer, nameOffset, nameLen)) {
            this.inPreformattedElement = false;
        }
        this.getNext().handleCloseElementStart(buffer, nameOffset, nameLen, line, col);
    }

    public void handleCloseElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.lastTextEndedInWhiteSpace = false;
        this.lastClosedElementWasBlock = MinimizeHtmlMarkupHandler.isBlockElement(buffer, nameOffset, nameLen);
        this.lastOpenElementWasBlock = false;
        this.lastVisibleEventWasElement = true;
        this.getNext().handleCloseElementEnd(buffer, nameOffset, nameLen, line, col);
    }

    public void handleAutoCloseElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.lastTextEndedInWhiteSpace = false;
        boolean ignorePendingWhiteSpace = this.lastClosedElementWasBlock && MinimizeHtmlMarkupHandler.isBlockElement(buffer, nameOffset, nameLen);
        this.flushPendingInterBlockElementWhiteSpace(ignorePendingWhiteSpace);
        this.getNext().handleAutoCloseElementStart(buffer, nameOffset, nameLen, line, col);
    }

    public void handleAutoCloseElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.lastTextEndedInWhiteSpace = false;
        this.lastClosedElementWasBlock = MinimizeHtmlMarkupHandler.isBlockElement(buffer, nameOffset, nameLen);
        this.lastOpenElementWasBlock = false;
        this.lastVisibleEventWasElement = true;
        this.getNext().handleAutoCloseElementEnd(buffer, nameOffset, nameLen, line, col);
    }

    public void handleUnmatchedCloseElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.lastTextEndedInWhiteSpace = false;
        boolean ignorePendingWhiteSpace = this.lastClosedElementWasBlock && MinimizeHtmlMarkupHandler.isBlockElement(buffer, nameOffset, nameLen);
        this.flushPendingInterBlockElementWhiteSpace(ignorePendingWhiteSpace);
        this.getNext().handleUnmatchedCloseElementStart(buffer, nameOffset, nameLen, line, col);
    }

    public void handleUnmatchedCloseElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.lastTextEndedInWhiteSpace = false;
        this.lastClosedElementWasBlock = MinimizeHtmlMarkupHandler.isBlockElement(buffer, nameOffset, nameLen);
        this.lastOpenElementWasBlock = false;
        this.lastVisibleEventWasElement = true;
        this.getNext().handleUnmatchedCloseElementEnd(buffer, nameOffset, nameLen, line, col);
    }

    public void handleAttribute(char[] buffer, int nameOffset, int nameLen, int nameLine, int nameCol, int operatorOffset, int operatorLen, int operatorLine, int operatorCol, int valueContentOffset, int valueContentLen, int valueOuterOffset, int valueOuterLen, int valueLine, int valueCol) throws ParseException {
        boolean canRemoveAttributeQuotes;
        boolean isMinimizableBooleanAttribute;
        this.getNext().handleInnerWhiteSpace(SIZE_ONE_WHITE_SPACE, 0, SIZE_ONE_WHITE_SPACE.length, this.pendingEventLine, this.pendingEventCol);
        boolean bl = isMinimizableBooleanAttribute = this.minimizeMode.minimizeBooleanAttributes && MinimizeHtmlMarkupHandler.isBooleanAttribute(buffer, nameOffset, nameLen) && TextUtil.equals(false, buffer, nameOffset, nameLen, buffer, valueContentOffset, valueContentLen);
        if (isMinimizableBooleanAttribute) {
            this.getNext().handleAttribute(buffer, nameOffset, nameLen, nameLine, nameCol, 0, 0, operatorLine, operatorCol, 0, 0, 0, 0, operatorLen, operatorCol);
            return;
        }
        boolean bl2 = canRemoveAttributeQuotes = this.minimizeMode.unquoteAttributes && MinimizeHtmlMarkupHandler.canAttributeValueBeUnquoted(buffer, valueContentOffset, valueContentLen, valueOuterOffset, valueOuterLen);
        if (operatorLen <= 1 && !canRemoveAttributeQuotes) {
            this.getNext().handleAttribute(buffer, nameOffset, nameLen, nameLine, nameCol, operatorOffset, operatorLen, operatorLine, operatorCol, valueContentOffset, valueContentLen, valueOuterOffset, valueOuterLen, valueLine, valueCol);
        } else {
            int requiredLen = nameLen + 1 + valueOuterLen;
            if (this.internalBuffer.length < requiredLen) {
                this.internalBuffer = new char[requiredLen];
            }
            System.arraycopy(buffer, nameOffset, this.internalBuffer, 0, nameLen);
            System.arraycopy(ATTRIBUTE_OPERATOR, 0, this.internalBuffer, nameLen, ATTRIBUTE_OPERATOR.length);
            if (canRemoveAttributeQuotes) {
                System.arraycopy(buffer, valueContentOffset, this.internalBuffer, nameLen + ATTRIBUTE_OPERATOR.length, valueContentLen);
                this.getNext().handleAttribute(this.internalBuffer, 0, nameLen, nameLine, nameCol, nameLen, ATTRIBUTE_OPERATOR.length, operatorLine, operatorCol, nameLen + ATTRIBUTE_OPERATOR.length, valueContentLen, nameLen + ATTRIBUTE_OPERATOR.length, valueContentLen, valueLine, valueCol);
            } else {
                System.arraycopy(buffer, valueOuterOffset, this.internalBuffer, nameLen + ATTRIBUTE_OPERATOR.length, valueOuterLen);
                this.getNext().handleAttribute(this.internalBuffer, 0, nameLen, nameLine, nameCol, nameLen, ATTRIBUTE_OPERATOR.length, operatorLine, operatorCol, nameLen + ATTRIBUTE_OPERATOR.length + (valueOuterOffset - valueContentOffset), valueContentLen, nameLen + ATTRIBUTE_OPERATOR.length, valueOuterLen, valueLine, valueCol);
            }
        }
    }

    public void handleInnerWhiteSpace(char[] buffer, int offset, int len, int line, int col) throws ParseException {
        this.pendingEventLine = line;
        this.pendingEventCol = col;
    }

    public void handleDocType(char[] buffer, int keywordOffset, int keywordLen, int keywordLine, int keywordCol, int elementNameOffset, int elementNameLen, int elementNameLine, int elementNameCol, int typeOffset, int typeLen, int typeLine, int typeCol, int publicIdOffset, int publicIdLen, int publicIdLine, int publicIdCol, int systemIdOffset, int systemIdLen, int systemIdLine, int systemIdCol, int internalSubsetOffset, int internalSubsetLen, int internalSubsetLine, int internalSubsetCol, int outerOffset, int outerLen, int outerLine, int outerCol) throws ParseException {
        this.flushPendingInterBlockElementWhiteSpace(false);
        this.lastVisibleEventWasElement = false;
        this.lastTextEndedInWhiteSpace = false;
        this.getNext().handleDocType(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, elementNameOffset, elementNameLen, elementNameLine, elementNameCol, typeOffset, typeLen, typeLine, typeCol, publicIdOffset, publicIdLen, publicIdLine, publicIdCol, systemIdOffset, systemIdLen, systemIdLine, systemIdCol, internalSubsetOffset, internalSubsetLen, internalSubsetLine, internalSubsetCol, outerOffset, outerLen, outerLine, outerCol);
    }

    public void handleXmlDeclaration(char[] buffer, int keywordOffset, int keywordLen, int keywordLine, int keywordCol, int versionOffset, int versionLen, int versionLine, int versionCol, int encodingOffset, int encodingLen, int encodingLine, int encodingCol, int standaloneOffset, int standaloneLen, int standaloneLine, int standaloneCol, int outerOffset, int outerLen, int line, int col) throws ParseException {
        this.flushPendingInterBlockElementWhiteSpace(false);
        this.lastVisibleEventWasElement = false;
        this.lastTextEndedInWhiteSpace = false;
        this.getNext().handleXmlDeclaration(buffer, keywordOffset, keywordLen, keywordLine, keywordCol, versionOffset, versionLen, versionLine, versionCol, encodingOffset, encodingLen, encodingLine, encodingCol, standaloneOffset, standaloneLen, standaloneLine, standaloneCol, outerOffset, outerLen, line, col);
    }

    public void handleProcessingInstruction(char[] buffer, int targetOffset, int targetLen, int targetLine, int targetCol, int contentOffset, int contentLen, int contentLine, int contentCol, int outerOffset, int outerLen, int line, int col) throws ParseException {
        this.flushPendingInterBlockElementWhiteSpace(false);
        this.lastVisibleEventWasElement = false;
        this.lastTextEndedInWhiteSpace = false;
        this.getNext().handleProcessingInstruction(buffer, targetOffset, targetLen, targetLine, targetCol, contentOffset, contentLen, contentLine, contentCol, outerOffset, outerLen, line, col);
    }

    private static boolean canAttributeValueBeUnquoted(char[] buffer, int valueContentOffset, int valueContentLen, int valueOuterOffset, int valueOuterLen) {
        if (valueContentLen == 0 || valueOuterLen == valueContentLen) {
            return false;
        }
        int i = valueContentOffset;
        int n = valueContentLen;
        while (n-- != 0) {
            char c = buffer[i];
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r' || c == '\f' || c == '\u000b' || c == '\u001c' || c == '\u001d' || c == '\u001e' || c == '\u001f' || c > '\u007f' && Character.isWhitespace(c);
    }

    private static boolean isBlockElement(char[] buffer, int nameOffset, int nameLen) {
        return TextUtil.binarySearch(false, (CharSequence[])BLOCK_ELEMENTS, buffer, nameOffset, nameLen) >= 0;
    }

    private static boolean isPreformattedElement(char[] buffer, int nameOffset, int nameLen) {
        int i = 0;
        int n = PREFORMATTED_ELEMENTS.length;
        while (n-- != 0) {
            if (TextUtil.compareTo(false, (CharSequence)PREFORMATTED_ELEMENTS[i], 0, PREFORMATTED_ELEMENTS[i].length(), buffer, nameOffset, nameLen) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isBooleanAttribute(char[] buffer, int nameOffset, int nameLen) {
        return TextUtil.binarySearch(false, (CharSequence[])BOOLEAN_ATTRIBUTE_NAMES, buffer, nameOffset, nameLen) >= 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MinimizeMode {
        ONLY_WHITE_SPACE(false, false, false, false),
        COMPLETE(true, true, true, true);

        private boolean removeComments;
        private boolean unquoteAttributes;
        private boolean unminimizeStandalones;
        private boolean minimizeBooleanAttributes;

        private MinimizeMode(boolean removeComments, boolean unquoteAttributes, boolean unminimizeStandalones, boolean minimizeBooleanAttributes) {
            this.removeComments = removeComments;
            this.unquoteAttributes = unquoteAttributes;
            this.unminimizeStandalones = unminimizeStandalones;
            this.minimizeBooleanAttributes = minimizeBooleanAttributes;
        }
    }
}

