/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.report;

import de.otto.jlineup.Util;
import de.otto.jlineup.file.FileService;
import de.otto.jlineup.report.ScreenshotComparisonResult;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;

public class HTMLReportGenerator {
    private FileService fileService;

    public HTMLReportGenerator(FileService fileService) {
        this.fileService = fileService;
    }

    public void writeReport(List<ScreenshotComparisonResult> screenshotComparisonResults) throws FileNotFoundException {
        this.fileService.writeHtmlReport(this.renderReport("report", screenshotComparisonResults));
    }

    String renderReport(String template, List<ScreenshotComparisonResult> screenshotComparisonResults) throws FileNotFoundException {
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setTemplateMode("HTML");
        templateResolver.setPrefix("templates/");
        templateResolver.setSuffix(".html");
        TemplateEngine templateEngine = new TemplateEngine();
        templateEngine.setTemplateResolver(templateResolver);
        Map<String, Object> variables = this.prepareVariablesForReportTemplate(screenshotComparisonResults);
        return templateEngine.process(template, (IContext)new Context(Locale.US, variables));
    }

    private Map<String, Object> prepareVariablesForReportTemplate(List<ScreenshotComparisonResult> screenshotComparisonResults) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        LinkedList<ScreenshotComparisonResultContext> screenshotComparisonResultContexts = new LinkedList<ScreenshotComparisonResultContext>();
        String lastContextKey = null;
        ScreenshotComparisonResultContext currentContext = null;
        for (ScreenshotComparisonResult screenshotComparisonResult : screenshotComparisonResults) {
            String context = screenshotComparisonResult.url + "|||" + screenshotComparisonResult.width;
            if (!context.equals(lastContextKey)) {
                lastContextKey = context;
                currentContext = new ScreenshotComparisonResultContext(screenshotComparisonResult.url, screenshotComparisonResult.width);
                screenshotComparisonResultContexts.add(currentContext);
            }
            currentContext.addResult(screenshotComparisonResult);
        }
        variables.put("resultContexts", screenshotComparisonResultContexts);
        variables.put("jlineup_version", Util.readVersion());
        variables.put("jlineup_commit", Util.readCommit());
        return variables;
    }

    private class ScreenshotComparisonResultContext {
        private String url;
        private int width;
        private List<ScreenshotComparisonResult> results;

        public ScreenshotComparisonResultContext(String url, int width) {
            this.url = url;
            this.width = width;
            this.results = new LinkedList<ScreenshotComparisonResult>();
        }

        public void addResult(ScreenshotComparisonResult result) {
            this.results.add(result);
        }

        public String getUrl() {
            return this.url;
        }

        public int getWidth() {
            return this.width;
        }

        public List<ScreenshotComparisonResult> getResults() {
            return this.results;
        }

        public String getShortenedUrl() {
            String shortenedUrl = this.url;
            if (this.url.length() > 25) {
                shortenedUrl = "..." + shortenedUrl.substring(shortenedUrl.lastIndexOf("/"), shortenedUrl.length());
            }
            return shortenedUrl;
        }

        public boolean isSuccess() {
            for (ScreenshotComparisonResult result : this.results) {
                if (!(result.difference > 0.0)) continue;
                return false;
            }
            return true;
        }
    }
}

