/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import de.otto.jlineup.browser.Browser;
import de.otto.jlineup.config.Parameters;
import de.otto.jlineup.config.UrlConfig;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class Config {
    public static final String LINEUP_CONFIG_DEFAULT_PATH = "./lineup.json";
    public static final String EXAMPLE_URL = "https://www.example.com";
    public static final Browser.Type DEFAULT_BROWSER = Browser.Type.PHANTOMJS;
    public static final float DEFAULT_MAX_DIFF = 0.0f;
    public static final int DEFAULT_WINDOW_HEIGHT = 800;
    public static final float DEFAULT_ASYNC_WAIT = 0.0f;
    public static final List<Integer> DEFAULT_WINDOW_WIDTHS = ImmutableList.of(Integer.valueOf(800));
    public static final List<String> DEFAULT_PATHS = ImmutableList.of("/");
    public static final int DEFAULT_MAX_SCROLL_HEIGHT = 100000;
    public static final int DEFAULT_WAIT_AFTER_PAGE_LOAD = 0;
    public static final int DEFAULT_WAIT_FOR_NO_ANIMATION_AFTER_SCROLL = 0;
    public static final int DEFAULT_WARMUP_BROWSER_CACHE_TIME = 0;
    public final Map<String, UrlConfig> urls;
    public final Browser.Type browser;
    @SerializedName(value="wait-after-page-load", alternate={"async-wait"})
    public final Float globalWaitAfterPageLoad;
    @SerializedName(value="window-height")
    public final Integer windowHeight;
    private static final Gson gson = new Gson();

    public Config() {
        this.urls = null;
        this.browser = DEFAULT_BROWSER;
        this.globalWaitAfterPageLoad = Float.valueOf(0.0f);
        this.windowHeight = 800;
    }

    public Config(Map<String, UrlConfig> urls, Browser.Type browser, Float globalWaitAfterPageLoad, Integer windowHeight) {
        this.urls = urls;
        this.browser = browser != null ? browser : DEFAULT_BROWSER;
        this.globalWaitAfterPageLoad = Float.valueOf(globalWaitAfterPageLoad != null ? globalWaitAfterPageLoad.floatValue() : 0.0f);
        this.windowHeight = windowHeight != null ? windowHeight : 800;
    }

    public static Config defaultConfig() {
        return Config.defaultConfig(EXAMPLE_URL);
    }

    public static Config defaultConfig(String url) {
        return new Config(ImmutableMap.of(url, new UrlConfig()), null, null, null);
    }

    public static Config readConfig(Parameters parameters) throws FileNotFoundException {
        return Config.readConfig(parameters.getWorkingDirectory(), parameters.getConfigFile());
    }

    public static Config readConfig(String workingDir, String configFileName) throws FileNotFoundException {
        ArrayList<String> searchPaths = new ArrayList<String>();
        Path configFilePath = Paths.get(workingDir + "/" + configFileName, new String[0]);
        searchPaths.add(configFilePath.toString());
        if (!Files.exists(configFilePath, new LinkOption[0])) {
            configFilePath = Paths.get(configFileName, new String[0]);
            searchPaths.add(configFilePath.toString());
            if (!Files.exists(configFilePath, new LinkOption[0])) {
                configFilePath = Paths.get(LINEUP_CONFIG_DEFAULT_PATH, new String[0]);
                searchPaths.add(configFilePath.toString());
                if (!Files.exists(configFilePath, new LinkOption[0])) {
                    throw new FileNotFoundException("Config file not found. Search locations were: " + Arrays.toString(searchPaths.toArray()));
                }
            }
        }
        BufferedReader br = new BufferedReader(new FileReader(configFilePath.toString()));
        return gson.fromJson((Reader)br, Config.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        if (this.urls != null ? !this.urls.equals(config.urls) : config.urls != null) {
            return false;
        }
        if (this.browser != config.browser) {
            return false;
        }
        if (this.globalWaitAfterPageLoad != null ? !this.globalWaitAfterPageLoad.equals(config.globalWaitAfterPageLoad) : config.globalWaitAfterPageLoad != null) {
            return false;
        }
        return this.windowHeight != null ? this.windowHeight.equals(config.windowHeight) : config.windowHeight == null;
    }

    public int hashCode() {
        int result = this.urls != null ? this.urls.hashCode() : 0;
        result = 31 * result + (this.browser != null ? this.browser.hashCode() : 0);
        result = 31 * result + (this.globalWaitAfterPageLoad != null ? this.globalWaitAfterPageLoad.hashCode() : 0);
        result = 31 * result + (this.windowHeight != null ? this.windowHeight.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Config{urls=" + this.urls + ", browser=" + (Object)((Object)this.browser) + ", globalWaitAfterPageLoad=" + this.globalWaitAfterPageLoad + ", windowHeight=" + this.windowHeight + '}';
    }
}

