/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.browser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.firefox.internal.Executable;
import org.openqa.selenium.remote.service.DriverService;

class JLineupGeckoDriverService
extends GeckoDriverService {
    public JLineupGeckoDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    static class Builder
    extends DriverService.Builder<GeckoDriverService, GeckoDriverService.Builder> {
        Builder() {
        }

        @Override
        protected File findDefaultExecutable() {
            return JLineupGeckoDriverService.findExecutable("wires", "webdriver.gecko.driver", "https://github.com/jgraham/wires", "https://github.com/jgraham/wires");
        }

        @Override
        protected ImmutableList<String> createArgs() {
            ImmutableList.Builder argsBuilder = ImmutableList.builder();
            argsBuilder.add(String.format("--webdriver-port=%d", this.getPort()));
            if (this.getLogFile() != null) {
                argsBuilder.add(String.format("--log-file=\"%s\"", this.getLogFile().getAbsolutePath()));
            }
            argsBuilder.add("-b");
            argsBuilder.add(new Executable(null).getPath());
            return argsBuilder.build();
        }

        @Override
        protected GeckoDriverService createDriverService(File exe, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) {
            try {
                return new GeckoDriverService(exe, port, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

