/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.browser;

import de.otto.jlineup.browser.BrowserUtils;
import de.otto.jlineup.browser.ScreenshotContext;
import de.otto.jlineup.config.Config;
import de.otto.jlineup.config.Cookie;
import de.otto.jlineup.config.Parameters;
import de.otto.jlineup.file.FileService;
import de.otto.jlineup.image.ImageService;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Browser
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(Browser.class);
    static final String JS_DOCUMENT_HEIGHT_CALL = "return Math.max( document.body.scrollHeight, document.body.offsetHeight, document.documentElement.clientHeight, document.documentElement.scrollHeight, document.documentElement.offsetHeight );";
    static final String JS_CLIENT_VIEWPORT_HEIGHT_CALL = "return document.documentElement.clientHeight";
    static final String JS_SET_LOCAL_STORAGE_CALL = "localStorage.setItem('%s','%s')";
    static final String JS_SCROLL_CALL = "window.scrollBy(0,%d)";
    static final String JS_SCROLL_TO_TOP_CALL = "window.scrollTo(0, 0);";
    private final Parameters parameters;
    private final Config config;
    private final WebDriver driver;
    private final FileService fileService;

    public Browser(Parameters parameters, Config config, WebDriver driver, FileService fileService) {
        this.parameters = parameters;
        this.config = config;
        this.driver = driver;
        this.fileService = fileService;
        driver.manage().timeouts().implicitlyWait(60L, TimeUnit.SECONDS);
    }

    public void takeScreenshots() throws IOException, InterruptedException {
        boolean before = !this.parameters.isAfter();
        List<ScreenshotContext> screenshotContextList = BrowserUtils.buildScreenshotContextListFromConfigAndState(this.parameters, this.config, before);
        this.takeScreenshots(screenshotContextList);
    }

    @Override
    public void close() {
        if (this.driver != null) {
            this.driver.close();
            this.driver.quit();
        }
    }

    void takeScreenshots(List<ScreenshotContext> screenshotContextList) throws IOException, InterruptedException {
        HashSet<String> browserCacheWarmupMarks = new HashSet<String>();
        block2: for (ScreenshotContext screenshotContext : screenshotContextList) {
            this.driver.manage().window().setPosition(new Point(0, 0));
            this.driver.manage().window().setSize(new Dimension(screenshotContext.windowWidth, this.config.windowHeight));
            String url = BrowserUtils.buildUrl(screenshotContext.url, screenshotContext.path, screenshotContext.urlConfig.envMapping);
            String rootUrl = BrowserUtils.buildUrl(screenshotContext.url, "/", screenshotContext.urlConfig.envMapping);
            if (this.areThereCookiesOrLocalStorage(screenshotContext)) {
                LOG.info(String.format("Getting root url: %s to set cookies and local storage", rootUrl));
                this.driver.get(rootUrl);
                this.setCookies(screenshotContext);
                this.setLocalStorage(screenshotContext);
            }
            LOG.info(String.format("Browsing to %s with window size %dx%d", url, screenshotContext.windowWidth, this.config.windowHeight));
            this.driver.get(url);
            this.checkBrowserCacheWarmup(browserCacheWarmupMarks, screenshotContext, url, this.driver);
            Long pageHeight = this.getPageHeight();
            Long viewportHeight = this.getViewportHeight();
            if (screenshotContext.urlConfig.waitAfterPageLoad > 0) {
                try {
                    LOG.debug(String.format("Waiting for %d seconds (wait-after-page-load)", screenshotContext.urlConfig.waitAfterPageLoad));
                    Thread.sleep(screenshotContext.urlConfig.waitAfterPageLoad * 1000);
                }
                catch (InterruptedException e) {
                    LOG.error(e.getMessage(), e);
                }
            }
            if (this.config.globalWaitAfterPageLoad.floatValue() > 0.0f) {
                LOG.debug(String.format("Waiting for %s seconds (global wait-after-page-load)", this.config.globalWaitAfterPageLoad));
                Thread.sleep(Math.round(this.config.globalWaitAfterPageLoad.floatValue() * 1000.0f));
            }
            LOG.debug("Page height before scrolling: {}", (Object)pageHeight);
            LOG.debug("Viewport height of browser window: {}", (Object)viewportHeight);
            this.scrollToTop();
            this.executeJavaScript(screenshotContext.urlConfig.javaScript);
            int yPosition = 0;
            while ((long)yPosition < pageHeight && yPosition <= screenshotContext.urlConfig.maxScrollHeight) {
                BufferedImage currentScreenshot = this.takeScreenshot();
                currentScreenshot = this.waitForNoAnimation(screenshotContext, currentScreenshot);
                this.fileService.writeScreenshot(currentScreenshot, screenshotContext.url, screenshotContext.path, screenshotContext.windowWidth, yPosition, screenshotContext.before ? "before" : "after");
                if (this.config.browser == Type.PHANTOMJS) continue block2;
                LOG.debug("topOfViewport: {}, pageHeight: {}", (Object)yPosition, (Object)pageHeight);
                this.scrollBy(viewportHeight.intValue());
                pageHeight = this.getPageHeight();
                yPosition = (int)((long)yPosition + viewportHeight);
            }
        }
    }

    private boolean areThereCookiesOrLocalStorage(ScreenshotContext screenshotContext) {
        return screenshotContext.urlConfig.cookies != null && screenshotContext.urlConfig.cookies.size() > 0 || screenshotContext.urlConfig.localStorage != null && screenshotContext.urlConfig.localStorage.size() > 0;
    }

    private void setCookies(ScreenshotContext screenshotContext) {
        if (this.config.browser == Type.PHANTOMJS) {
            LOG.debug("Setting cookies for PhantomJS");
            this.setCookiesPhantomJS(screenshotContext.urlConfig.cookies);
        } else {
            LOG.debug("Setting cookies");
            this.setCookies(screenshotContext.urlConfig.cookies);
        }
    }

    private void checkBrowserCacheWarmup(Set<String> cacheWarmupMarks, ScreenshotContext screenshotContext, String url, WebDriver driver) {
        int warmupTime = screenshotContext.urlConfig.warmupBrowserCacheTime;
        if (warmupTime > 0 && !cacheWarmupMarks.contains(url)) {
            LOG.debug(String.format("First call of %s - waiting %d seconds for cache warmup", url, warmupTime));
            cacheWarmupMarks.add(url);
            try {
                Thread.sleep(warmupTime * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            LOG.debug("Cache warmup time is over. Getting " + url + " again.");
            driver.get(url);
        }
    }

    private BufferedImage takeScreenshot() throws IOException {
        File screenshot = ((TakesScreenshot)((Object)this.driver)).getScreenshotAs(OutputType.FILE);
        return ImageIO.read(screenshot);
    }

    private BufferedImage waitForNoAnimation(ScreenshotContext screenshotContext, BufferedImage currentScreenshot) throws IOException {
        float waitForNoAnimation = screenshotContext.urlConfig.waitForNoAnimationAfterScroll;
        if (waitForNoAnimation > 0.0f) {
            long beginTime = System.currentTimeMillis();
            int sameCounter = 0;
            while (sameCounter < 10 && !this.timeIsOver(beginTime, waitForNoAnimation)) {
                File screenshot = ((TakesScreenshot)((Object)this.driver)).getScreenshotAs(OutputType.FILE);
                BufferedImage newScreenshot = ImageIO.read(screenshot);
                if (ImageService.bufferedImagesEqualQuick(newScreenshot, currentScreenshot)) {
                    ++sameCounter;
                }
                currentScreenshot = newScreenshot;
            }
        }
        return currentScreenshot;
    }

    private boolean timeIsOver(long beginTime, float waitForNoAnimation) {
        boolean over;
        boolean bl = over = beginTime + (long)(waitForNoAnimation * 1000.0f) < System.currentTimeMillis();
        if (over) {
            LOG.debug("Time is over");
        }
        return over;
    }

    private Long getPageHeight() {
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.driver);
        return (Long)jse.executeScript(JS_DOCUMENT_HEIGHT_CALL, new Object[0]);
    }

    private Long getViewportHeight() {
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.driver);
        return (Long)jse.executeScript(JS_CLIENT_VIEWPORT_HEIGHT_CALL, new Object[0]);
    }

    void executeJavaScript(String javaScript) throws InterruptedException {
        if (javaScript == null) {
            return;
        }
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.driver);
        jse.executeScript(javaScript, new Object[0]);
        Thread.sleep(50L);
    }

    void scrollBy(int viewportHeight) throws InterruptedException {
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.driver);
        jse.executeScript(String.format(JS_SCROLL_CALL, viewportHeight), new Object[0]);
        Thread.sleep(50L);
    }

    void scrollToTop() throws InterruptedException {
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.driver);
        jse.executeScript(JS_SCROLL_TO_TOP_CALL, new Object[0]);
        Thread.sleep(50L);
    }

    private void setLocalStorage(ScreenshotContext screenshotContext) {
        this.setLocalStorage(screenshotContext.urlConfig.localStorage);
    }

    void setLocalStorage(Map<String, String> localStorage) {
        if (localStorage == null) {
            return;
        }
        JavascriptExecutor jse = (JavascriptExecutor)((Object)this.driver);
        for (Map.Entry<String, String> localStorageEntry : localStorage.entrySet()) {
            String entry = localStorageEntry.getValue().replace("'", "\"");
            String jsCall = String.format(JS_SET_LOCAL_STORAGE_CALL, localStorageEntry.getKey(), entry);
            jse.executeScript(jsCall, new Object[0]);
        }
    }

    void setCookies(List<Cookie> cookies) {
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            Cookie.Builder cookieBuilder = new Cookie.Builder(cookie.name, cookie.value);
            if (cookie.domain != null) {
                cookieBuilder.domain(cookie.domain);
            }
            if (cookie.path != null) {
                cookieBuilder.path(cookie.path);
            }
            if (cookie.expiry != null) {
                cookieBuilder.expiresOn(cookie.expiry);
            }
            cookieBuilder.isSecure(cookie.secure);
            this.driver.manage().addCookie(cookieBuilder.build());
        }
    }

    void setCookiesPhantomJS(List<Cookie> cookies) {
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            StringBuilder cookieCallBuilder = new StringBuilder(String.format("document.cookie = '%s=%s;", cookie.name, cookie.value));
            if (cookie.path != null) {
                cookieCallBuilder.append("path=");
                cookieCallBuilder.append(cookie.path);
                cookieCallBuilder.append(";");
            }
            if (cookie.domain != null) {
                cookieCallBuilder.append("domain=");
                cookieCallBuilder.append(cookie.domain);
                cookieCallBuilder.append(";");
            }
            if (cookie.secure) {
                cookieCallBuilder.append("secure;");
            }
            if (cookie.expiry != null) {
                cookieCallBuilder.append("expires=");
                SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", Locale.US);
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                String asGmt = df.format(cookie.expiry.getTime()) + " GMT";
                cookieCallBuilder.append(asGmt);
                cookieCallBuilder.append(";");
            }
            cookieCallBuilder.append("'");
            ((JavascriptExecutor)((Object)this.driver)).executeScript(cookieCallBuilder.toString(), new Object[0]);
        }
    }

    public static enum Type {
        FIREFOX,
        CHROME,
        PHANTOMJS;

    }
}

