/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.Downloader;
import io.github.bonigarcia.wdm.WdmConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class EdgeDriverManager
extends BrowserManager {
    private static EdgeDriverManager instance;

    public static synchronized EdgeDriverManager getInstance() {
        if (instance == null) {
            instance = new EdgeDriverManager();
        }
        return instance;
    }

    @Override
    public List<URL> getDrivers() throws Exception {
        String edgeDriverUrl = WdmConfig.getString("wdm.edgeDriverUrl");
        log.debug("Reading {} to find out the latest version of Edge driver", (Object)edgeDriverUrl);
        Document doc = Jsoup.connect(edgeDriverUrl).timeout((int)TimeUnit.SECONDS.toMillis(WdmConfig.getInt("wdm.timeout"))).proxy(Downloader.createProxy()).get();
        Elements downloadLink = doc.select(".mscom-link.download-button.dl");
        Elements versionParagraph = doc.select("div:nth-child(1) > div > p");
        this.versionToDownload = ((Element)versionParagraph.get(0)).text();
        String secondPage = edgeDriverUrl.substring(0, edgeDriverUrl.lastIndexOf("/") + 1) + ((Element)downloadLink.get(0)).attr("href");
        doc = Jsoup.connect(secondPage).timeout((int)TimeUnit.SECONDS.toMillis(WdmConfig.getInt("wdm.timeout"))).proxy(Downloader.createProxy()).get();
        Elements binaryLink = doc.select(".mscom-link.failoverLink");
        ArrayList<URL> urlList = new ArrayList<URL>();
        urlList.add(new URL(binaryLink.attr("href")));
        return urlList;
    }

    @Override
    protected String getExportParameter() {
        return WdmConfig.getString("wdm.edgeExport");
    }

    @Override
    protected String getDriverVersion() {
        return WdmConfig.getString("wdm.edgeVersion");
    }

    @Override
    protected URL getDriverUrl() throws MalformedURLException {
        return WdmConfig.getUrl("wdm.edgeDriverUrl");
    }

    @Override
    protected List<String> getDriverName() {
        return Arrays.asList("MicrosoftWebDriver");
    }
}

