/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.report;

import java.nio.file.Paths;

public class ScreenshotComparisonResult {
    public final String url;
    public final int width;
    public final int verticalScrollPosition;
    public final double difference;
    public final String screenshotBeforeFileName;
    public final String screenshotAfterFileName;
    public final String differenceImageFileName;

    public ScreenshotComparisonResult(String url, int width, int verticalScrollPosition, double difference, String screenshotBeforeFileName, String screenshotAfterFileName, String differenceImageFileName) {
        this.url = url;
        this.width = width;
        this.verticalScrollPosition = verticalScrollPosition;
        this.difference = difference;
        this.screenshotBeforeFileName = screenshotBeforeFileName != null ? Paths.get(screenshotBeforeFileName, new String[0]).getFileName().toString() : null;
        this.screenshotAfterFileName = screenshotAfterFileName != null ? Paths.get(screenshotAfterFileName, new String[0]).getFileName().toString() : null;
        this.differenceImageFileName = differenceImageFileName != null ? Paths.get(differenceImageFileName, new String[0]).getFileName().toString() : null;
    }

    public static ScreenshotComparisonResult noBeforeImageComparisonResult(String url, int width, int verticalScrollPosition, String screenshotAfterFileName) {
        return new ScreenshotComparisonResult(url, width, verticalScrollPosition, 1.0, null, screenshotAfterFileName, null);
    }

    public static ScreenshotComparisonResult noAfterImageComparisonResult(String url, int width, int verticalScrollPosition, String screenshotBeforeFileName) {
        return new ScreenshotComparisonResult(url, width, verticalScrollPosition, 1.0, screenshotBeforeFileName, null, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreenshotComparisonResult that = (ScreenshotComparisonResult)o;
        if (this.width != that.width) {
            return false;
        }
        if (this.verticalScrollPosition != that.verticalScrollPosition) {
            return false;
        }
        if (Double.compare(that.difference, this.difference) != 0) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        if (this.screenshotBeforeFileName != null ? !this.screenshotBeforeFileName.equals(that.screenshotBeforeFileName) : that.screenshotBeforeFileName != null) {
            return false;
        }
        if (this.screenshotAfterFileName != null ? !this.screenshotAfterFileName.equals(that.screenshotAfterFileName) : that.screenshotAfterFileName != null) {
            return false;
        }
        return this.differenceImageFileName != null ? this.differenceImageFileName.equals(that.differenceImageFileName) : that.differenceImageFileName == null;
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + this.width;
        result = 31 * result + this.verticalScrollPosition;
        long temp = Double.doubleToLongBits(this.difference);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.screenshotBeforeFileName != null ? this.screenshotBeforeFileName.hashCode() : 0);
        result = 31 * result + (this.screenshotAfterFileName != null ? this.screenshotAfterFileName.hashCode() : 0);
        result = 31 * result + (this.differenceImageFileName != null ? this.differenceImageFileName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ScreenshotComparisonResult{url='" + this.url + '\'' + ", width=" + this.width + ", verticalScrollPosition=" + this.verticalScrollPosition + ", difference=" + this.difference + ", screenshotBeforeFileName='" + this.screenshotBeforeFileName + '\'' + ", screenshotAfterFileName='" + this.screenshotAfterFileName + '\'' + ", differenceImageFileName='" + this.differenceImageFileName + '\'' + '}';
    }
}

